/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.content.items.modular206.GauntletItemNew;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class GauntletRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation _textureLoc = XyMachines.resource("textures/block/simple.png");
    private static final ResourceLocation _emissiveLocation = XyMachines.resource("textures/models/armor/test.png");

    public GauntletRenderLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull LivingEntity entity, float yaw, float pitch, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        boolean main = entity.getItemBySlot(EquipmentSlot.MAINHAND).getItem() instanceof GauntletItemNew;
        boolean off = entity.getItemBySlot(EquipmentSlot.OFFHAND).getItem() instanceof GauntletItemNew;
        if (!off && !main) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        int color = XyCraftColors.Red.getColor();
        color = entity instanceof Player || entity.hasData(CoreAttachments.Color) ? ColorUtils.multiply((int)FavoredColor.of((IAttachmentHolder)entity), (float)1.0f) : FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer());
        ModelPart modelPart = model.rightArm;
        if (main) {
            modelPart = entity.getMainArm().getId() == 1 ? model.rightArm : model.leftArm;
            poseStack.pushPose();
            modelPart.translateAndRotate(poseStack);
            MachinesModelBakery.Gauntlet.render(poseStack, bufferSource, RenderType.entityCutout((ResourceLocation)_textureLoc), light, color);
            poseStack.popPose();
        }
        if (off) {
            modelPart = entity.getMainArm().getId() == 0 ? model.rightArm : model.leftArm;
            poseStack.pushPose();
            modelPart.translateAndRotate(poseStack);
            poseStack.mulPose(new Quaternionf().rotationY((float)java.lang.Math.PI));
            MachinesModelBakery.Gauntlet.render(poseStack, bufferSource, RenderType.entityCutout((ResourceLocation)_textureLoc), light, color);
            poseStack.popPose();
        }
    }

    public static <T extends LivingEntity> void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            GauntletRenderLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.renderers.values()) {
            GauntletRenderLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        GauntletRenderLayer layer = new GauntletRenderLayer(livingRenderer);
        livingRenderer.addLayer(layer);
    }

    @SubscribeEvent
    public static void renderInHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isInvisible() || !(event.getItemStack().getItem() instanceof GauntletItemNew)) {
            return;
        }
        boolean flag = event.getHand() == InteractionHand.MAIN_HAND;
        PoseStack pose = event.getPoseStack();
        HumanoidArm humanoidarm = flag ? player.getMainArm() : player.getMainArm().getOpposite();
        pose.pushPose();
        GauntletRenderLayer.renderPlayerArm((AbstractClientPlayer)player, pose, event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), humanoidarm);
        pose.popPose();
    }

    private static void renderPlayerArm(AbstractClientPlayer player, PoseStack pose, MultiBufferSource bufferSource, int packedLight, float equipProgress, float swingProgress, HumanoidArm arm) {
        pose.pushPose();
        boolean flag = arm == HumanoidArm.RIGHT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Math.sqrt((float)swingProgress);
        float f2 = -0.3f * Mth.sin((float)(f1 * (float)java.lang.Math.PI));
        float f3 = 0.4f * Mth.sin((float)(f1 * ((float)java.lang.Math.PI * 2)));
        float f4 = -0.4f * Mth.sin((float)(swingProgress * (float)java.lang.Math.PI));
        pose.translate(f * (f2 + 0.64000005f), f3 - 0.6f + equipProgress * -0.6f - 0.2f, f4 - 0.71999997f);
        pose.mulPose(Axis.YP.rotationDegrees(f * 45.0f));
        float f5 = Mth.sin((float)(swingProgress * swingProgress * (float)java.lang.Math.PI));
        float f6 = Mth.sin((float)(f1 * (float)java.lang.Math.PI));
        pose.mulPose(Axis.YP.rotationDegrees(f * f6 * 70.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(f * f5 * -20.0f));
        pose.translate(f * -1.0f, 3.6f, 3.5f);
        pose.mulPose(Axis.ZP.rotationDegrees(f * 120.0f));
        pose.mulPose(Axis.XP.rotationDegrees(200.0f));
        pose.mulPose(Axis.YP.rotationDegrees(f * -135.0f));
        pose.translate(f * 5.6f, 0.0f, 0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        int color = FavoredColor.of((IAttachmentHolder)player);
        if (flag) {
            playerrenderer.renderRightHand(pose, bufferSource, packedLight, player);
            ((PlayerModel)playerrenderer.getModel()).rightArm.translateAndRotate(pose);
            pose.pushPose();
            MachinesModelBakery.Gauntlet.render(pose, bufferSource, RenderType.entityTranslucent((ResourceLocation)_textureLoc), packedLight, color);
            pose.popPose();
        } else {
            playerrenderer.renderLeftHand(pose, bufferSource, packedLight, player);
            ((PlayerModel)playerrenderer.getModel()).leftArm.translateAndRotate(pose);
            pose.mulPose(new Quaternionf().rotationY((float)java.lang.Math.PI));
            MachinesModelBakery.Gauntlet.render(pose, bufferSource, RenderType.entityTranslucent((ResourceLocation)_textureLoc), packedLight, color);
        }
        pose.popPose();
    }
}

