/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotSetPacket;
import tv.soaryn.xycraft.core.ui.slots.GhostSlot;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;
import tv.soaryn.xycraft.machines.gui.FabricatorMenu;

public class FabricatorTransferHandler
implements IRecipeTransferHandler<FabricatorMenu, RecipeHolder<CraftingRecipe>> {
    @NotNull
    public Class<? extends FabricatorMenu> getContainerClass() {
        return FabricatorMenu.class;
    }

    @NotNull
    public Optional<MenuType<FabricatorMenu>> getMenuType() {
        return Optional.of((MenuType)MachinesMenus.Fabricator.get());
    }

    @NotNull
    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull FabricatorMenu container, @NotNull RecipeHolder<CraftingRecipe> holder, @NotNull IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        List views = recipeSlots.getSlotViews();
        Slot[] slots = (Slot[])container.slots.stream().filter(Slot::isActive).filter(GhostSlot.class::isInstance).toArray(Slot[]::new);
        if (doTransfer) {
            boolean key = ModifierKey.ofClient();
            for (int i = 0; i < ((FabricatorAttachment)container.BlockEntity.getData(MachinesAttachments.Block.FabricatorData)).Ghost.size(); ++i) {
                boolean isStrict;
                ItemStack item = ((IRecipeSlotView)views.get((i + 1) % 10)).getDisplayedItemStack().orElse(ItemStack.EMPTY);
                Slot slot = slots[i];
                boolean bl = isStrict = !item.isEmpty() && key && i != 9;
                if (!(slot instanceof GhostSlot)) continue;
                XyCore.Network.send((Packet.ServerBound)new SBGhostSlotSetPacket(slot.index, item, isStrict));
            }
            container.broadcastChanges();
            container.BlockEntity.setChanged();
        }
        return null;
    }
}

