/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.neoforged.neoforge.event.village.VillageSiegeEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.volumes.LightFieldVolume;

public class LightFieldBlock
extends ColoredBlock
implements ITooltipProvider {
    public LightFieldBlock(BlockBehaviour.Properties properties) {
        super((IColorSource)XyCraftColors.Light, properties.randomTicks());
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource randSource) {
        super.randomTick(blockState, level, pos, randSource);
        VolumeLevelAttachment.add((Level)level, (BlockPos)pos, MachinesAttachments.Block.LightFieldVolumeData);
    }

    public void appendToolTip(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)this.getToolTipKey(0)).withStyle(ChatFormatting.GRAY));
        if (ModifierKey.ofClient()) {
            String s = String.valueOf(XyMachines.ServerConfig.LightFieldRange.get());
            components.add((Component)Component.translatable((String)this.getToolTipKey(1), (Object[])new Object[]{s}).withColor(-5592321));
        }
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.add((Level)serverLevel, (BlockPos)pos, MachinesAttachments.Block.LightFieldVolumeData);
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.remove((Level)serverLevel, (BlockPos)pos, MachinesAttachments.Block.LightFieldVolumeData);
        }
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(LightFieldBlock::stopEnderWarp);
        NeoForge.EVENT_BUS.addListener(LightFieldBlock::preventSiege);
        NeoForge.EVENT_BUS.addListener(LightFieldBlock::blockMobSpawn);
        NeoForge.EVENT_BUS.addListener(LightFieldBlock::blockSpecialSpawns);
        NeoForge.EVENT_BUS.addListener(LightFieldBlock::blockPhantomSpawn);
    }

    public static void stopEnderWarp(EntityTeleportEvent.EnderEntity event) {
        if (!((Boolean)XyMachines.ServerConfig.LightFieldPreventEndermenWarpIn.get()).booleanValue()) {
            return;
        }
        BlockPos pos = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getEntity().level(), LightFieldVolume.class);
        volumes.find(pos).findFirst().ifPresent($ -> event.setCanceled(true));
    }

    public static void preventSiege(VillageSiegeEvent event) {
        if (!((Boolean)XyMachines.ServerConfig.LightFieldPreventsSieges.get()).booleanValue()) {
            return;
        }
        Vec3 vec = event.getAttemptedSpawnPos();
        BlockPos pos = new BlockPos((int)vec.x(), (int)vec.y(), (int)vec.z());
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getLevel(), LightFieldVolume.class);
        volumes.find(pos).findFirst().ifPresent($ -> event.setCanceled(true));
    }

    public static void blockPhantomSpawn(PlayerSpawnPhantomsEvent event) {
        Player player = event.getEntity();
        BlockPos pos = player.blockPosition();
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)player.level(), LightFieldVolume.class);
        if (volumes.find(pos).findAny().isEmpty()) {
            return;
        }
        event.setPhantomsToSpawn(0);
        event.setResult(PlayerSpawnPhantomsEvent.Result.DENY);
    }

    public static void blockSpecialSpawns(FinalizeSpawnEvent event) {
        FastVolumeLookup volumes;
        Mob entity = event.getEntity();
        if (event.isCanceled() || LightFieldBlock.isAllowed(event.getSpawnType())) {
            return;
        }
        if ((entity.getType() == EntityType.PILLAGER || entity.getType() == EntityType.WANDERING_TRADER || entity.getType() == EntityType.TRADER_LLAMA) && (volumes = FastVolumeLookup.of((Level)event.getLevel().getLevel(), LightFieldVolume.class)).find(entity.blockPosition()).findFirst().isPresent()) {
            event.setCanceled(true);
            event.setSpawnCancelled(true);
        }
    }

    public static void blockMobSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        if (event.getResult() != MobSpawnEvent.SpawnPlacementCheck.Result.DEFAULT || LightFieldBlock.isAllowed(event.getSpawnType())) {
            return;
        }
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getLevel().getLevel(), LightFieldVolume.class);
        volumes.find(event.getPos()).findFirst().ifPresent(lightFieldVolumeAnchor -> event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL));
    }

    private static boolean isAllowed(MobSpawnType type) {
        return switch (type) {
            case MobSpawnType.BREEDING, MobSpawnType.COMMAND, MobSpawnType.MOB_SUMMONED, MobSpawnType.CONVERSION, MobSpawnType.BUCKET, MobSpawnType.SPAWN_EGG, MobSpawnType.DISPENSER, MobSpawnType.TRIAL_SPAWNER -> true;
            case MobSpawnType.NATURAL, MobSpawnType.TRIGGERED, MobSpawnType.PATROL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.SPAWNER, MobSpawnType.STRUCTURE, MobSpawnType.JOCKEY, MobSpawnType.REINFORCEMENT, MobSpawnType.EVENT -> false;
            default -> {
                XyMachines.Logger.debug("There is a missing type not handled:%s. Raise an issue on the tracker if there isn't already one `%s`".formatted(type.name(), "https://github.com/Soaryn/XyCraftTracker/issues"));
                yield false;
            }
        };
    }
}

