/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.TankMemberBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.FluidMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IMultiTankMember;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class ItemIOBlock
extends XyBlock.WithEntity
implements IColoredBlock,
ITooltipProvider.BlockDefault {
    private static final VoxelShape Shape = Shapes.join((VoxelShape)ItemIOBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)ItemIOBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public ItemIOBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion(), Entity::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Axis, (Comparable)Direction.Axis.Y)).setValue((Property)MachineStateProperties.Initialized, (Comparable)Boolean.valueOf(false))).setValue(MachineStateProperties.FluidMode, (Comparable)((Object)FluidMode.FILL)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{CoreStateProperties.Axis});
        stateBuilder.add(new Property[]{MachineStateProperties.Initialized});
        stateBuilder.add(new Property[]{MachineStateProperties.FluidMode});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (WrenchCapability.isValidToolInMainHand((Player)player, (InteractionHand)hand, (boolean)false)) {
            BlockState newState = (BlockState)state.cycle(MachineStateProperties.FluidMode);
            BlockEntity bEntity = level.getBlockEntity(pos);
            level.setBlockAndUpdate(pos, newState);
            level.sendBlockUpdated(pos, newState, newState, 3);
            level.markAndNotifyBlock(pos, level.getChunkAt(pos), newState, newState, 3, 512);
            if (bEntity instanceof TankMemberBlockEntity) {
                TankMemberBlockEntity tankMember = (TankMemberBlockEntity)bEntity;
                level.invalidateCapabilities(pos);
                bEntity.setChanged();
                tankMember.getMultiBlocks().forEach(tankMember::setMultiBlock);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        FluidMode mode = (FluidMode)((Object)state.getValue(MachineStateProperties.FluidMode));
        if (mode == FluidMode.FILL) {
            return XyCraftColors.Green.getColor();
        }
        if (mode == FluidMode.DRAIN) {
            return -1605342;
        }
        return super.getColorOfBlock(state, level, pos, index);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return index == -1 ? -1 : XyCraftColors.Green.getColor();
    }

    @EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
    public static class Entity
    extends TankMemberBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.ItemIo.entity(), pos, state);
        }

        @SubscribeEvent
        private static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, MachinesContent.Block.ItemIo.entity(), (object, context) -> {
                Entity io;
                block3: {
                    block2: {
                        if (!(object instanceof Entity)) break block2;
                        io = (Entity)object;
                        if (io.tank != null) break block3;
                    }
                    return null;
                }
                FluidMode mode = (FluidMode)((Object)((Object)io.getBlockState().getValue(MachineStateProperties.FluidMode)));
                return mode == FluidMode.FILL ? io.tank.getFillItemHandler() : io.tank.getDrainItemHandler();
            });
            event.registerBlockEntity(IMultiTankMember.BLOCK, MachinesContent.Block.ItemIo.entity(), (blockEntity, context) -> {
                TankMemberBlockEntity valve;
                return blockEntity instanceof TankMemberBlockEntity ? (valve = (TankMemberBlockEntity)blockEntity) : null;
            });
        }
    }
}

