/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.utils.ColorSource;

public enum ColorFilter implements StringRepresentable
{
    None("none", null),
    WHITE("white", DyeColor.WHITE),
    ORANGE("orange", DyeColor.ORANGE),
    MAGENTA("magenta", DyeColor.MAGENTA),
    LIGHT_BLUE("light_blue", DyeColor.LIGHT_BLUE),
    YELLOW("yellow", DyeColor.YELLOW),
    LIME("lime", DyeColor.LIME),
    PINK("pink", DyeColor.PINK),
    GRAY("gray", DyeColor.GRAY),
    LIGHT_GRAY("light_gray", DyeColor.LIGHT_GRAY),
    CYAN("cyan", DyeColor.CYAN),
    PURPLE("purple", DyeColor.PURPLE),
    BLUE("blue", DyeColor.BLUE),
    BROWN("brown", DyeColor.BROWN),
    GREEN("green", DyeColor.GREEN),
    RED("red", DyeColor.RED),
    BLACK("black", DyeColor.BLACK);

    private final String _name;
    private final IColorSource _color;
    private final DyeColor _referenceColor;
    private static final Lazy<Reference2ReferenceMap<DyeColor, ColorFilter>> _filterMap;
    public static final StringRepresentable.StringRepresentableCodec<ColorFilter> CODEC;

    private ColorFilter(String name, DyeColor color) {
        this._name = name;
        this._referenceColor = color;
        this._color = new ColorSource.Dye(color);
    }

    @NotNull
    public String getSerializedName() {
        return this._name;
    }

    public int getColor() {
        if (this == None) {
            return -1;
        }
        return this._color.getColor();
    }

    public static ColorFilter from(DyeColor color) {
        return (ColorFilter)((Object)((Reference2ReferenceMap)_filterMap.get()).get((Object)color));
    }

    public ColorFilter next() {
        ColorFilter[] filters = ColorFilter.values();
        return filters[(this.ordinal() + 1) % filters.length];
    }

    public ColorFilter prev() {
        ColorFilter[] filters = ColorFilter.values();
        int index = this.ordinal() - 1;
        if (index < 0) {
            index = filters.length - 1;
        }
        return filters[index];
    }

    static {
        _filterMap = Lazy.of(() -> {
            Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
            for (ColorFilter value : ColorFilter.values()) {
                map.put((Object)value._referenceColor, (Object)value);
            }
            return map;
        });
        CODEC = StringRepresentable.fromEnum(ColorFilter::values);
    }
}

