/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.content.items.IHandleCreativeTab;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.utils.handlers.EnergyHandlerUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class XynergyStorageItem
extends XyItem.Experimental
implements IHandleCreativeTab {
    private final ModConfigSpec.IntValue _capacityConfig;

    public XynergyStorageItem(ModConfigSpec.IntValue capacityConfig) {
        super(new Item.Properties().stacksTo(1).setNoRepair().component((Supplier)CoreItemDataComponents.EnergyCapacity, (Object)250).component((Supplier)CoreItemDataComponents.EnergyStored, (Object)0));
        this._capacityConfig = capacityConfig;
    }

    public void verifyComponentsAfterLoad(@NotNull ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (XyMachines.ServerConfig.getSpec().isLoaded()) {
            stack.set((Supplier)CoreItemDataComponents.EnergyCapacity, (Object)this._capacityConfig.getAsInt());
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isSelectedSlot) {
        super.inventoryTick(stack, level, entity, slot, isSelectedSlot);
        if (level.isClientSide() || !isSelectedSlot) {
            return;
        }
        long tick = Ticks.of((IAttachmentHolder)level);
        if (tick % 10L != 0L) {
            return;
        }
        IEnergyStorage cap = EnergyHandlerUtils.getItemCapability((ItemStack)stack);
        if (cap != null) {
            cap.receiveEnergy(1, false);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.is(newStack.getItem());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        IEnergyStorage cap = EnergyHandlerUtils.getItemCapability((ItemStack)stack);
        if (cap == null) {
            return;
        }
        int capacity = cap.getMaxEnergyStored();
        if (capacity > 0) {
            components.add((Component)Component.literal((String)" Capacity: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"%d".formatted(capacity)).withColor(-7820545)));
            components.add((Component)Component.literal((String)" Charge: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"%d%%".formatted(cap.getEnergyStored() * 100 / capacity)).withColor(-10027162)));
        }
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (tooltipFlag.isAdvanced()) {
            components.add((Component)Component.literal((String)" Absolute: %d / %d".formatted(cap.getEnergyStored(), capacity)).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public void handle(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() != MachinesContent.Map.getTab().get()) {
            return;
        }
        event.accept(this.getDefaultInstance());
        ItemStack filledStack = this.getDefaultInstance();
        filledStack.set((Supplier)CoreItemDataComponents.EnergyStored, (Object)this._capacityConfig.getAsInt());
        event.accept(filledStack);
    }
}

