/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.logic;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnergyConsumer;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.core.content.attachments.accessors.PlayerPowerLookup;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.handlers.EnergyHandlerUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.MachinesModules;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.MineLogicModule;
import tv.soaryn.xycraft.machines.content.items.modular206.GauntletItemNew;
import tv.soaryn.xycraft.machines.content.recipes.solidifier.SolidifierRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.network.CBHardenBlockPacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
interface BreakBlockGauntletEvent {
    public static final Set<BlockPos> _blocksHarvested = new ObjectOpenHashSet();
    public static final RandomSource source = RandomSource.createNewThreadLocalInstance();

    @SubscribeEvent
    public static void handleTickEndEvent(ServerTickEvent.Post event) {
        _blocksHarvested.clear();
    }

    @SubscribeEvent
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        IEnergyConsumer consumable;
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = player2.getMainHandItem();
        if (!(stack.getItem() instanceof GauntletItemNew)) {
            return;
        }
        IModuleContainer moduleStorage = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM);
        if (moduleStorage == null) {
            return;
        }
        List moduleList = moduleStorage.getInstalledModules();
        MineLogicModule module = null;
        boolean hasFreezeModule = false;
        for (IModuleContainer.ModuleRecord moduleRecord : moduleList) {
            IModule iModule = moduleRecord.module();
            if (iModule instanceof MineLogicModule) {
                MineLogicModule found;
                module = found = (MineLogicModule)iModule;
            }
            if (moduleRecord.module() != MachinesModules.Tunneler.value()) continue;
            hasFreezeModule = true;
        }
        BlockPos origin = event.getPos();
        if (_blocksHarvested.contains(origin)) {
            return;
        }
        Level level = player2.level();
        Direction dir = BreakBlockGauntletEvent.getTargetLookDirection((Player)player2);
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        if (module == null || !((Boolean)stack.getOrDefault(MachinesDataComponents.ToolActivation, (Object)false)).booleanValue()) {
            blockPositions.add(origin);
        } else {
            blockPositions.addAll(module.logic().getPositions(level, origin, dir, 1).map(BlockPos::immutable).toList());
        }
        if (blockPositions.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> frozenBlocks = new ArrayList<BlockPos>();
        if (hasFreezeModule) {
            for (BlockPos blockPosition : blockPositions) {
                for (Direction value : Direction.values()) {
                    BlockPos checkPos = blockPosition.relative(value);
                    if (blockPositions.contains(checkPos) || frozenBlocks.contains(checkPos) || !BreakBlockGauntletEvent.canFreeze(level, checkPos)) continue;
                    frozenBlocks.add(checkPos);
                }
            }
            frozenBlocks.removeAll(MineLogicModule.getRadiusBlocks(origin.relative(dir.getOpposite()), dir, 1).map(BlockPos::immutable).toList());
        }
        int energyPerAction = (consumable = (IEnergyConsumer)stack.getCapability(CoreCapabilities.EnergyConsumable.ITEM)) != null ? consumable.amountRequired((Player)player2) : 0;
        int energyRequired = player2.isCreative() ? 0 : (frozenBlocks.size() + blockPositions.size()) * energyPerAction;
        PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of((Player)player2);
        lookup.invalidate(player2.getInventory());
        long result = lookup.loop((long)energyRequired, EnergyHandlerUtils::simulateDrain);
        if (result < (long)energyRequired) {
            return;
        }
        BlockState originState = level.getBlockState(origin);
        float originSpeed = originState.getDestroySpeed((BlockGetter)level, origin);
        if (originSpeed < 0.001f) {
            blockPositions.removeIf(pos -> level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) > 0.001f);
        }
        long actualActions = 0L;
        actualActions += (long)frozenBlocks.stream().mapToInt(pos -> BreakBlockGauntletEvent.freeze(level, pos) ? 1 : 0).sum();
        lookup.loop((long)energyPerAction * ((actualActions += (long)blockPositions.stream().mapToInt(pos -> {
            _blocksHarvested.add((BlockPos)pos);
            boolean handled = player.gameMode.destroyBlock(pos);
            _blocksHarvested.remove(pos);
            if (!level.getBlockState(pos).getFluidState().isEmpty()) {
                BlockState air = Blocks.AIR.defaultBlockState();
                level.setBlockAndUpdate(pos, air);
            }
            return handled ? 1 : 0;
        }).sum()) + 1L), EnergyHandlerUtils::executeDrain);
    }

    public static boolean canFreeze(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)MachinesRecipeTypes.Solidifier.type().get(), (RecipeInput)((SolidifierRecipe.Input)() -> state), level);
        return recipe.isPresent() || !state.getFluidState().isEmpty();
    }

    @NotNull
    public static Direction getTargetLookDirection(Player player) {
        Vec3 playerLook = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 lookVec = player.getViewVector(1.0f);
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 endLook = playerLook.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        BlockHitResult hitResult = player.level().clip(new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult.getDirection().getOpposite();
    }

    private static boolean freeze(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)MachinesRecipeTypes.Solidifier.type().get(), (RecipeInput)((SolidifierRecipe.Input)() -> state), level);
        if (recipe.isEmpty()) {
            if (!state.getFluidState().isEmpty()) {
                BlockState newState = MachinesContent.Block.CoagulatedWater.block().defaultBlockState();
                level.setBlock(pos, newState, 11);
                XyMachines.Network.broadcast((Packet.ClientBound)new CBHardenBlockPacket(pos, state));
                return true;
            }
            return false;
        }
        XyMachines.Network.broadcast((Packet.ClientBound)new CBHardenBlockPacket(pos, state));
        level.setBlock(pos, ((SolidifierRecipe)((RecipeHolder)recipe.get()).value()).result(), 11);
        return true;
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        IEnergyConsumer energyConsumer;
        if (event.isCanceled()) {
            return;
        }
        float speed = event.getNewSpeed();
        Player player = event.getEntity();
        Level level = event.getEntity().level();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof GauntletItemNew)) {
            return;
        }
        IModuleContainer moduleStorage = (IModuleContainer)stack.getCapability(CoreCapabilities.ModuleContainer.ITEM);
        if (moduleStorage == null || event.getPosition().isEmpty()) {
            return;
        }
        List moduleList = moduleStorage.getInstalledModules();
        List<IModule> modulesOnly = moduleList.stream().map(IModuleContainer.ModuleRecord::module).toList();
        MineLogicModule mineLogic = MineLogicModule.of(moduleStorage);
        if ((!player.onGround() || player.isUnderWater()) && modulesOnly.contains(MachinesModules.EnvironmentalProcessing.value())) {
            speed *= 5.0f;
        }
        int energyRequired = (energyConsumer = (IEnergyConsumer)stack.getCapability(CoreCapabilities.EnergyConsumable.ITEM)) != null && !player.isCreative() ? energyConsumer.amountRequired(player) : 0;
        PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of((Player)player);
        lookup.invalidate(player.getInventory());
        if (mineLogic == null) {
            if (energyRequired > 0 && lookup.loop((long)energyRequired, EnergyHandlerUtils::simulateDrain) < (long)energyRequired) {
                speed = 0.1f;
            }
            event.setNewSpeed(speed);
            return;
        }
        Direction dir = BreakBlockGauntletEvent.getTargetLookDirection(player);
        List<BlockPos> blockPositions = mineLogic.logic().getPositions(level, (BlockPos)event.getPosition().get(), dir, 1).map(BlockPos::immutable).toList();
        float originSpeed = event.getState().getDestroySpeed((BlockGetter)level, (BlockPos)event.getPosition().get());
        Float slowestSpeed = blockPositions.stream().filter(pos -> !level.getBlockState(pos).liquid()).map(pos -> {
            BlockState state = level.getBlockState(pos);
            return Float.valueOf(state.getDestroySpeed((BlockGetter)level, pos));
        }).max(Float::compareTo).orElse(Float.valueOf(1.0f));
        if (originSpeed > 0.0f) {
            speed *= originSpeed;
        }
        speed /= slowestSpeed.floatValue();
        if ((energyRequired *= blockPositions.size()) > 0 && lookup.loop((long)energyRequired, EnergyHandlerUtils::simulateDrain) < (long)energyRequired) {
            speed = 0.5f;
        }
        event.setNewSpeed(speed);
    }
}

