/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.SpecialPlantable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IGrowHandler;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowableImplementations;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowthType;
import tv.soaryn.xycraft.core.content.blocks.prototype.IGrowable;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class PlanterTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    private static final Map<Block, IGrowable> _growableMap = new HashMap<Block, IGrowable>();

    public PlanterTickSystem() {
        _growableMap.put(Blocks.CACTUS, GrowableImplementations.ThreeTall);
        _growableMap.put(Blocks.SUGAR_CANE, GrowableImplementations.ThreeTall);
        _growableMap.put(Blocks.PITCHER_CROP, GrowableImplementations.Crop);
        _growableMap.put(Blocks.TORCHFLOWER_CROP, GrowableImplementations.Crop);
        _growableMap.put(Blocks.WHEAT, GrowableImplementations.Crop);
        _growableMap.put(Blocks.POTATOES, GrowableImplementations.Crop);
        _growableMap.put(Blocks.BEETROOTS, GrowableImplementations.Crop);
        _growableMap.put(Blocks.NETHER_WART, GrowableImplementations.NetherWart);
        _growableMap.put(Blocks.CHORUS_FLOWER, GrowableImplementations.ChorusFruit);
        _growableMap.put(Blocks.CHORUS_PLANT, GrowableImplementations.ChorusFruit);
        _growableMap.put(Blocks.COCOA, GrowableImplementations.CocoaBean);
        _growableMap.put(Blocks.BAMBOO, GrowableImplementations.Bamboo);
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        float hit = level.random.nextFloat();
        if (hit > 0.75f) {
            return;
        }
        this.attemptGrow(state, level, (BlockPos)pos, level.random);
    }

    public void attemptGrow(@NotNull BlockState blockState, ServerLevel level, BlockPos pos, @NotNull RandomSource randSource) {
        block15: {
            int planterCount;
            Block plantBlock;
            Direction dir;
            block16: {
                if (blockState.isAir()) {
                    return;
                }
                dir = (Direction)blockState.getValue((Property)CoreStateProperties.StateDirection);
                Direction supportingPlanterDirection = dir.getOpposite();
                BlockPos plantLocation = pos.relative(dir);
                BlockState focusedBlockState = level.getBlockState(plantLocation);
                plantBlock = focusedBlockState.getBlock();
                if (plantBlock == MachinesContent.Block.Planter.block() || focusedBlockState.isAir()) {
                    return;
                }
                for (planterCount = 1; level.getBlockState(pos.relative(supportingPlanterDirection, planterCount)) == blockState && planterCount <= (Integer)XyMachines.ServerConfig.PlanterLimit.get(); ++planterCount) {
                }
                IGrowHandler growablecap = (IGrowHandler)level.getCapability(IGrowHandler.BLOCK, plantLocation);
                if (growablecap != null) {
                    Set listOfPositions = growablecap.grow(GrowthType.Random, planterCount);
                    for (BlockPos growthPosition : listOfPositions) {
                        level.levelEvent(2011, growthPosition, 15);
                    }
                    return;
                }
                IGrowable growable = _growableMap.get(plantBlock);
                ObjectArraySet listOfPositions = new ObjectArraySet();
                if (growable != null) {
                    while (planterCount-- > 0) {
                        Set positionsUpdated = growable.grow(level.getBlockState(plantLocation), level, plantLocation, randSource, GrowthType.Random, 1);
                        listOfPositions.addAll((Collection)positionsUpdated);
                    }
                    if (!level.isClientSide() && !listOfPositions.isEmpty()) {
                        for (BlockPos blockPos : listOfPositions) {
                            level.levelEvent(1505, blockPos, 15);
                        }
                    }
                    return;
                }
                if (focusedBlockState.is(MachinesContent.Block.Planter.block())) break block15;
                if (plantBlock instanceof BonemealableBlock) break block16;
                if (!(plantBlock instanceof SpecialPlantable)) break block15;
                SpecialPlantable plantable = (SpecialPlantable)plantBlock;
                if (blockState.canSustainPlant((BlockGetter)level, pos, dir, focusedBlockState).isFalse()) break block15;
            }
            int topPlant = 1;
            BlockState plantCheck = level.getBlockState(pos.relative(dir, topPlant + 1));
            while (plantCheck.is(plantBlock)) {
                plantCheck = level.getBlockState(pos.relative(dir, ++topPlant + 1));
            }
            if (!level.getBlockState(pos.relative(dir, topPlant)).isRandomlyTicking()) {
                return;
            }
            level.levelEvent(1505, pos.relative(dir, topPlant), 15);
            while (planterCount-- > 0) {
                BlockState activePlant = level.getBlockState(pos.relative(dir, topPlant));
                activePlant.randomTick(level, pos.relative(dir, topPlant), randSource);
            }
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.PlanterSystemData;
    }

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Planter.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Planter.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Planter at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }
}

