/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles;

import com.matyrobbrt.keybindbundles.ModKeyBindBundles;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.Nullable;

public class KeyMappingUtil {
    private static final Minecraft MC = Minecraft.getInstance();
    public static final List<KeyMapping> KEYS_TAKEN_OVER = new ArrayList<KeyMapping>();

    @Nullable
    public static KeyMapping getByName(String name) {
        return (KeyMapping)KeyMapping.ALL.get(name);
    }

    public static void press(KeyMapping mapping) {
        if (mapping == KeyMappingUtil.MC.options.keyFullscreen) {
            MC.getWindow().toggleFullScreen();
            KeyMappingUtil.MC.options.fullscreen().set((Object)MC.getWindow().isFullscreen());
            return;
        }
        if (mapping == KeyMappingUtil.MC.options.keyScreenshot) {
            Screenshot.grab((File)KeyMappingUtil.MC.gameDirectory, (RenderTarget)MC.getMainRenderTarget(), message -> MC.execute(() -> KeyMappingUtil.MC.gui.getChat().addMessage(message)));
            return;
        }
        mapping.takeOverForBundle();
        KEYS_TAKEN_OVER.add(mapping);
        mapping.setDown(true);
        ClientHooks.onKeyInput((int)ModKeyBindBundles.BUNDLE_TRIGGER_KEY.getValue(), (int)0, (int)1, (int)0);
    }

    public static void click(KeyMapping map) {
        map.incrementClickCount();
    }

    public static void release(KeyMapping map) {
        map.setDown(false);
        ClientHooks.onKeyInput((int)ModKeyBindBundles.BUNDLE_TRIGGER_KEY.getValue(), (int)0, (int)0, (int)0);
        map.restoreToOriginalKey();
        KEYS_TAKEN_OVER.remove(map);
    }

    public static void restoreAll() {
        if (!KEYS_TAKEN_OVER.isEmpty()) {
            for (KeyMapping keyMapping : KEYS_TAKEN_OVER) {
                keyMapping.restoreToOriginalKey();
                if (!keyMapping.isDown()) continue;
                keyMapping.setDown(false);
            }
            KEYS_TAKEN_OVER.clear();
        }
    }
}

