/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.mixin;

import com.matyrobbrt.keybindbundles.KBClientConfig;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InputConstants.class}, priority=1500)
public class InputConstantsMixin {
    @Unique
    private static final Set<Class<?>> IGNORED_INVALID_CALLSITES = new CopyOnWriteArraySet();

    @Inject(at={@At(value="HEAD")}, method={"isKeyDown"}, cancellable=true)
    private static void isCustomKeyDown(long window, int key, CallbackInfoReturnable<Boolean> cir) {
        if (key <= 0 && KBClientConfig.IGNORE_INVALID_KEY_CHECKS.getAsBoolean()) {
            Class caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).filter(c -> c != InputConstants.class).findFirst()).orElse(null);
            if (caller != null && IGNORED_INVALID_CALLSITES.add(caller)) {
                LogUtils.getLogger().error("Class {} attempted to call InputConstants#isKeyDown with an invalid key code {}. This error will be suppressed for this class going forward", new Object[]{caller, key, new Throwable("Invalid key code " + key)});
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (key == 22745) {
            cir.setReturnValue((Object)true);
        }
    }
}

