/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.HashSet;
import java.util.Set;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.containers.PolyBlockContainerMenu;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.creeperhost.polylib.data.serializable.EnumData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PolyBlockEntity
extends BlockEntity
implements Nameable,
DataManagerBlock,
DataRetainingBlock {
    private final TileDataManager<PolyBlockEntity> dataManager = new TileDataManager<PolyBlockEntity>(this);
    private final Set<Player> accessingPlayers = new HashSet<Player>();
    private Component customName = null;
    private int tick = 0;
    private EnumData<RedstoneActivatedBlock.RSMode> redstoneMode = null;
    private BooleanData isPowered = null;

    public PolyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (this instanceof RedstoneActivatedBlock) {
            this.redstoneMode = this.register("rs_mode", new EnumData<RedstoneActivatedBlock.RSMode>(RedstoneActivatedBlock.RSMode.ALWAYS_ACTIVE), 9, 4, 2);
            this.isPowered = this.register("rs_powered", new BooleanData(false), 8, 4);
        }
    }

    public TileDataManager<PolyBlockEntity> getDataManager() {
        return this.dataManager;
    }

    public <D extends AbstractDataStore<?>> D register(String name, D data, int ... flags) {
        return this.dataManager.register(name, data, flags);
    }

    public void tick() {
        ++this.tick;
        this.dataManager.tick();
    }

    public Set<Player> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt0$temp = e.containerMenu;
            if (!(patt0$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt0$temp;
            if (container.tile == this) return false;
            return true;
        });
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(Player player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(Player player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt0$temp = e.containerMenu;
            if (!(patt0$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt0$temp;
            if (container.tile == this) return false;
            return true;
        });
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    public Component getName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.dataManager.save(provider, compoundTag);
        this.writeExtraData(provider, compoundTag);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.dataManager.load(provider, compoundTag);
        this.readExtraData(provider, compoundTag);
    }

    @Override
    public void writeToItemStack(HolderLookup.Provider provider, CompoundTag nbt, boolean willHarvest) {
        this.dataManager.saveToItem(provider, nbt);
        this.writeExtraData(provider, nbt);
    }

    @Override
    public void readFromItemStack(HolderLookup.Provider provider, CompoundTag nbt) {
        this.dataManager.loadFromItem(provider, nbt);
        this.readExtraData(provider, nbt);
    }

    public void writeExtraData(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    public void readExtraData(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public RedstoneActivatedBlock.RSMode getRSMode() {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return (RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get());
    }

    public void setRSMode(RedstoneActivatedBlock.RSMode mode) {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        if (this.level.isClientSide) {
            this.sendDataValueToServer(this.redstoneMode, (Object)mode);
        } else {
            this.redstoneMode.set(mode);
        }
    }

    public void cycleRSMode(boolean reverse) {
        this.redstoneMode.set(((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).next(reverse));
    }

    public boolean isTileEnabled() {
        if (this instanceof RedstoneActivatedBlock) {
            return ((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).canRun((Boolean)this.isPowered.get());
        }
        return true;
    }

    public void onNeighborChange(Block fromBlock, BlockPos fromPos, boolean isMoving) {
        if (this instanceof RedstoneActivatedBlock) {
            boolean lastSignal = (Boolean)this.isPowered.get();
            this.isPowered.set(this.level.hasNeighborSignal(this.worldPosition));
            if ((Boolean)this.isPowered.get() != lastSignal) {
                this.onSignalChange((Boolean)this.isPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }
}

