/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part;

import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.base.multiblock.part.INeverCauseRenderingSkip;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.block.property.BlockFacingsProperty;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GlassBlock<Controller extends IMultiblockController<Controller>, PartType extends IMultiblockPartType>
extends GenericDeviceBlock<Controller, PartType>
implements INeverCauseRenderingSkip {
    public GlassBlock(MultiblockPartBlock.MultiblockPartProperties<PartType> properties) {
        super(properties);
    }

    public static BlockBehaviour.Properties addGlassProperties(BlockBehaviour.Properties originals) {
        return originals.sound(SoundType.GLASS).noOcclusion().isViewBlocking((blockState, blockReader, pos) -> false);
    }

    @Override
    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this == adjacentBlockState.getBlock();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
        super.buildBlockState(builder);
        builder.add(new Property[]{BlockFacingsProperty.FACINGS});
    }

    @Override
    protected BlockState buildDefaultState(BlockState state) {
        return (BlockState)super.buildDefaultState(state).setValue(BlockFacingsProperty.FACINGS, (Comparable)((Object)BlockFacingsProperty.None));
    }
}

