/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.client.gui.databind;

import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.event.SlimEvent;
import java.lang.invoke.StringConcatFactory;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Binding<Value>
implements IBinding {
    private final Supplier<Value> _supplier;
    private final IEvent<Consumer<Value>> _consumerEvent;
    private Value _cache = null;

    public static <Value> IBinding from(Supplier<Value> supplier, Consumer<Value> consumer) {
        SlimEvent<Consumer<Value>> e = new SlimEvent<Consumer<Value>>();
        e.subscribe(Objects.requireNonNull(consumer));
        return new Binding<Value>(supplier, e);
    }

    @SafeVarargs
    public static <Value> IBinding from(Supplier<Value> supplier, Consumer<Value> ... consumers) {
        Event<Consumer<Value>> e = new Event<Consumer<Value>>();
        for (Consumer<Value> consumer : consumers) {
            e.subscribe(Objects.requireNonNull(consumer));
        }
        return new Binding<Value>(supplier, e);
    }

    @Override
    public void update() {
        Object current = this._supplier.get();
        if (null == this._cache || !this._cache.equals(current)) {
            this._cache = current;
            this._consumerEvent.raise(c -> c.accept(current));
        }
    }

    @Override
    public void close() {
        this._consumerEvent.unsubscribeAll();
    }

    public String toString() {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Cached value: null"}) != this._cache ? this._cache.toString() : "null";
    }

    private Binding(Supplier<Value> supplier, IEvent<Consumer<Value>> consumer) {
        this._supplier = supplier;
        this._consumerEvent = consumer;
    }
}

