/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.network.AbstractPlayPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public final class ErrorReportMessage
extends AbstractPlayPacket<ErrorReportMessage> {
    public static final CustomPacketPayload.Type<ErrorReportMessage> TYPE = ErrorReportMessage.createType(ZeroCore.ROOT_LOCATION, "error");
    public static final StreamCodec<RegistryFriendlyByteBuf, ErrorReportMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), packet -> Optional.ofNullable(packet._position), (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), packet -> packet._errors, ErrorReportMessage::new);
    private final List<Component> _errors;
    @Nullable
    private final BlockPos _position;

    public ErrorReportMessage(@Nullable BlockPos position, List<Component> errors) {
        super(TYPE);
        Preconditions.checkNotNull(errors, (Object)"Errors must not but null");
        Preconditions.checkArgument((!errors.isEmpty() ? 1 : 0) != 0, (Object)"Errors must not be empty");
        this._position = position;
        this._errors = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(errors));
    }

    @Override
    public void handlePacket(IPayloadContext context) {
        if (PacketFlow.CLIENTBOUND == context.flow()) {
            ZeroCore.getProxy().displayErrorToPlayer(this._position, this._errors);
        }
    }

    private ErrorReportMessage(Optional<BlockPos> position, List<Component> errors) {
        super(TYPE);
        Preconditions.checkNotNull(errors, (Object)"Errors must not but null");
        Preconditions.checkArgument((!errors.isEmpty() ? 1 : 0) != 0, (Object)"Errors must not be empty");
        this._position = position.orElse(null);
        this._errors = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(errors));
    }
}

