/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.network.AbstractBlockEntityPlayPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ModSyncableTileMessage
extends AbstractBlockEntityPlayPacket<ModSyncableTileMessage> {
    public static final CustomPacketPayload.Type<ModSyncableTileMessage> TYPE = ModSyncableTileMessage.createType(ZeroCore.ROOT_LOCATION, "tile_sync");
    public static final StreamCodec<ByteBuf, ModSyncableTileMessage> STREAM_CODEC = ModSyncableTileMessage.createStreamCodec(ByteBufCodecs.BOOL, packet -> packet._nested, ByteBufCodecs.COMPOUND_TAG, packet -> packet._payload, ModSyncableTileMessage::new);
    private final CompoundTag _payload;
    private final boolean _nested;

    public static ModSyncableTileMessage create(Level entityLevel, BlockPos entityPosition, ISyncableEntity entity) {
        return ModSyncableTileMessage.create(entityLevel, entityPosition, entity, false);
    }

    public static ModSyncableTileMessage create(Level entityLevel, BlockPos entityPosition, INestedSyncableEntity nestedEntity) {
        Preconditions.checkNotNull((Object)nestedEntity, (Object)"Nested entity must not be null");
        ISyncableEntity entity = nestedEntity.getNestedSyncableEntity().orElseThrow(() -> new UnsupportedOperationException("Unable to create a sync message for an empty nested syncable entity"));
        return ModSyncableTileMessage.create(entityLevel, entityPosition, entity, true);
    }

    @Override
    protected void processBlockEntity(PacketFlow flow, BlockEntity tileEntity) {
        if (null == tileEntity.getLevel()) {
            Log.LOGGER.error(Log.NETWORK, "Refusing to sync a BlockEntity without a valid level");
            return;
        }
        ISyncableEntity entity = null;
        if (tileEntity instanceof INestedSyncableEntity && this._nested) {
            entity = ((INestedSyncableEntity)tileEntity).getNestedSyncableEntity().orElse(null);
        } else if (tileEntity instanceof ISyncableEntity) {
            entity = (ISyncableEntity)tileEntity;
        }
        if (null != entity) {
            entity.syncDataFrom(this._payload, (HolderLookup.Provider)tileEntity.getLevel().registryAccess(), ISyncableEntity.SyncReason.NetworkUpdate);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No syncable {}entity found while processing a sync message", (Object)(this._nested ? "(nested) " : ""));
        }
    }

    private static ModSyncableTileMessage create(Level entityLevel, BlockPos entityPosition, ISyncableEntity entity, boolean nested) {
        Preconditions.checkNotNull((Object)entityLevel, (Object)"Entity level must not be null");
        Preconditions.checkNotNull((Object)entityPosition, (Object)"Entity position must not be null");
        Preconditions.checkNotNull((Object)entity, (Object)"Entity must not be null");
        GlobalPos position = new GlobalPos(entityLevel.dimension(), entityPosition);
        CompoundTag payload = entity.syncDataTo(new CompoundTag(), (HolderLookup.Provider)entityLevel.registryAccess(), ISyncableEntity.SyncReason.NetworkUpdate);
        return new ModSyncableTileMessage(position, nested, payload);
    }

    private ModSyncableTileMessage(GlobalPos position, boolean nested, CompoundTag data) {
        super(TYPE, position);
        Preconditions.checkNotNull((Object)data, (Object)"Data must not be null");
        this._nested = nested;
        this._payload = data;
    }
}

