/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib;

import org.jetbrains.annotations.Nullable;

public class Ticker {
    private final int _expireAfter;
    private Runnable _expireCallback;
    private int _ticks;

    public Ticker(int expireAfterTicks) {
        this._expireAfter = expireAfterTicks;
        this._expireCallback = null;
        this._ticks = 0;
    }

    public void tick() {
        ++this._ticks;
        if (this._ticks >= this._expireAfter) {
            this._ticks = 0;
            if (null != this._expireCallback) {
                this._expireCallback.run();
            }
        }
    }

    public int getTicks() {
        return this._ticks;
    }

    public void reset() {
        this._ticks = 0;
    }

    protected Ticker setExpiredCallback(@Nullable Runnable expire) {
        this._expireCallback = expire;
        return this;
    }

    public String toString() {
        return String.format("Ticker: %d / %d", this._ticks, this._expireAfter);
    }
}

