/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

public class ModBakedModelSupplier {
    private final List<ModelResourceLocation> _toBeRegistered = new ObjectArrayList(32);
    private final Map<ModelResourceLocation, Wrapper> _wrappers = new Object2ObjectOpenHashMap(32);

    public ModBakedModelSupplier(IEventBus modBus) {
        modBus.register((Object)this);
    }

    public void addModel(ModelResourceLocation model) {
        if (!this._toBeRegistered.contains(model)) {
            this._toBeRegistered.add(model);
        }
    }

    public Supplier<BakedModel> getOrCreate(ModelResourceLocation model) {
        return this._wrappers.computeIfAbsent(model, $ -> new Wrapper());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRegisterModels(ModelEvent.RegisterAdditional event) {
        this._toBeRegistered.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelEvent.BakingCompleted event) {
        Map modelRegistry = event.getModels();
        BakedModel missing = ModRenderHelper.getMissingModel();
        this._wrappers.forEach((key, value) -> {
            value._cachedModel = modelRegistry.getOrDefault(key, missing);
        });
    }

    private static class Wrapper
    implements Supplier<BakedModel> {
        private BakedModel _cachedModel = null;

        protected Wrapper() {
        }

        @Override
        public BakedModel get() {
            return this._cachedModel;
        }
    }
}

