/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.AbstractDataProvider;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCodecDataProvider<T>
extends AbstractDataProvider {
    private final PackOutput.PathProvider _pathProvider;
    private final Codec<T> _codec;

    protected AbstractCodecDataProvider(String name, PackOutput output, PackOutput.Target target, String kind, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot, Codec<T> codec) {
        super(name, output, registryLookup, modLocationRoot);
        Preconditions.checkNotNull((Object)target, (Object)"Target must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)kind) ? 1 : 0) != 0, (Object)"Kind must not be null or empty");
        Preconditions.checkNotNull(codec, (Object)"Codec must not be null");
        this._pathProvider = output.createPathProvider(target, kind);
        this._codec = codec;
    }

    protected abstract void processData(BiConsumer<@NotNull ResourceLocation, @NotNull T> var1);

    @Override
    public CompletableFuture<?> processData(CachedOutput cache, HolderLookup.Provider registryLookup) {
        ObjectArrayList futures = new ObjectArrayList(64);
        this.processData((arg_0, arg_1) -> this.lambda$processData$0((List)futures, cache, arg_0, arg_1));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private /* synthetic */ void lambda$processData$0(List futures, CachedOutput cache, ResourceLocation id, Object value) {
        Path path = this._pathProvider.json(id);
        JsonElement json = (JsonElement)this._codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
        futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path));
    }
}

