/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelVariantBuilder {
    private final ModelVariantsList _sink;
    private final ModelBuilder _modelBuilder;
    private Variant _variant;
    private boolean _built;

    static void build(ModelVariantsList sink, ModelBuilder modelBuilder, Consumer<@NotNull ModelVariantBuilder> variantsBuilder) {
        Preconditions.checkNotNull((Object)sink, (Object)"Sink must not be null");
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull(variantsBuilder, (Object)"Variant builder must not be null");
        ModelVariantBuilder builder = new ModelVariantBuilder(sink, modelBuilder);
        variantsBuilder.accept(builder);
        if (!builder.isBuilt()) {
            builder.build();
        }
    }

    private ModelVariantBuilder(ModelVariantsList sink, ModelBuilder modelBuilder) {
        this._sink = sink;
        this._modelBuilder = modelBuilder;
        this._variant = Variant.variant();
        this._built = false;
    }

    public ModelVariantBuilder build() {
        this._sink.add(this._variant);
        this._variant = Variant.variant();
        this._built = true;
        return this;
    }

    boolean isBuilt() {
        return this._built;
    }

    public ModelVariantBuilder merge(Variant variant) {
        Preconditions.checkNotNull((Object)variant, (Object)"Variant must not be null");
        this._variant = Variant.merge((Variant)this._variant, (Variant)variant);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder model(ResourceLocation model) {
        Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
        this._variant.with(VariantProperties.MODEL, (Object)model);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder model(Function<@NotNull ModelBuilder, @NotNull ResourceLocation> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        ResourceLocation blockModel = builder.apply(this._modelBuilder);
        return this.model(blockModel);
    }

    public ModelVariantBuilder xRotation(VariantProperties.Rotation rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation must not be null");
        this._variant.with(VariantProperties.X_ROT, (Object)rotation);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder xRotation(int rotation) {
        Preconditions.checkArgument((0 == rotation || 90 == rotation || 180 == rotation || 270 == rotation ? 1 : 0) != 0, (Object)"Rotation can only be 0, 90, 180 or 270");
        return this.xRotation(VariantProperties.Rotation.valueOf((String)("R" + rotation)));
    }

    public ModelVariantBuilder yRotation(VariantProperties.Rotation rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation must not be null");
        this._variant.with(VariantProperties.Y_ROT, (Object)rotation);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder yRotation(int rotation) {
        Preconditions.checkArgument((0 == rotation || 90 == rotation || 180 == rotation || 270 == rotation ? 1 : 0) != 0, (Object)"Rotation can only be 0, 90, 180 or 270");
        return this.yRotation(VariantProperties.Rotation.valueOf((String)("R" + rotation)));
    }

    public ModelVariantBuilder uvLock() {
        return this.uvLock(true);
    }

    public ModelVariantBuilder uvLock(boolean enabled) {
        this._variant.with(VariantProperties.UV_LOCK, (Object)enabled);
        this._built = false;
        return this;
    }

    public ModelVariantBuilder weight(int weight) {
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be greater than or equal to one.");
        this._variant.with(VariantProperties.WEIGHT, (Object)weight);
        this._built = false;
        return this;
    }
}

