/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.data.models.blockstates.Variant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ModelVariantsList
implements BiFunction<String, JsonObject, JsonObject> {
    private final List<Variant> _modelVariants;

    protected ModelVariantsList(int initialCapacity) {
        Preconditions.checkArgument((initialCapacity > 0 ? 1 : 0) != 0);
        this._modelVariants = new ObjectArrayList(initialCapacity);
    }

    void add(Variant ... variants) {
        Collections.addAll(this._modelVariants, variants);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public JsonObject apply(@NotNull String name, @NotNull JsonObject parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        parent.add(name, Variant.convertList(this._modelVariants));
        return parent;
    }
}

