/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteData
extends AbstractData<Byte>
implements IContainerData {
    private byte _lastValue;

    public static ByteData immutable(ModContainer container, byte value) {
        return ByteData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static ByteData sampled(int frequency, ModContainer container, Supplier<@NotNull Byte> getter, Consumer<@NotNull Byte> clientSideSetter) {
        return ByteData.of(container, new Sampler<Byte>(frequency, getter), clientSideSetter);
    }

    public static ByteData sampled(int frequency, ModContainer container, Supplier<@NotNull Byte> getter) {
        return ByteData.of(container, new Sampler<Byte>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static ByteData of(ModContainer container, Supplier<@NotNull Byte> getter, Consumer<@NotNull Byte> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        ByteData data = container.isClientSide() ? new ByteData(getter, clientSideSetter) : new ByteData(getter);
        container.addBindableData(data);
        return data;
    }

    public static ByteData of(ModContainer container, byte[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return ByteData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static ByteData of(ModContainer container, Supplier<@NotNull Byte> getter) {
        return ByteData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        byte current = (Byte)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new ByteEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return ByteEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof ByteEntry) {
            ByteEntry record = (ByteEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Byte defaultValue() {
        return (byte)0;
    }

    private ByteData(Supplier<Byte> getter, Consumer<Byte> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private ByteData(Supplier<Byte> getter) {
        super(getter);
        this._lastValue = 0;
    }

    private record ByteEntry(byte value) implements ISyncedSetEntry
    {
        private static ByteEntry from(RegistryFriendlyByteBuf buffer) {
            return new ByteEntry(buffer.readByte());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeByte(this.value);
        }
    }
}

