/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackRecipeIngredientTag
implements IRecipeIngredient<FluidStack> {
    public static final ModCodecs<FluidStackRecipeIngredientTag, RegistryFriendlyByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(i -> i._tag), (App)Codec.INT.fieldOf("count").forGetter(i -> i._amount)).apply((Applicative)instance, FluidStackRecipeIngredientTag::new)), StreamCodec.composite(ModCodecs.tagKeyStreamCodec(Registries.FLUID), i -> i._tag, (StreamCodec)ByteBufCodecs.INT, i -> i._amount, FluidStackRecipeIngredientTag::new));
    private final TagKey<Fluid> _tag;
    private final int _amount;
    private List<FluidStack> _cachedMatchingElements;

    public static FluidStackRecipeIngredientTag from(TagKey<Fluid> tag, int amount) {
        return new FluidStackRecipeIngredientTag(tag, amount);
    }

    public static FluidStackRecipeIngredientTag from(FriendlyByteBuf buffer) {
        return new FluidStackRecipeIngredientTag(TagsHelper.FLUIDS.createKey(buffer.readResourceLocation()), buffer.readVarInt());
    }

    @Override
    public boolean isCompatible(FluidStack stack) {
        return Objects.requireNonNull(stack).getFluid().is(this._tag);
    }

    @Override
    public boolean isCompatible(FluidStack ... ingredients) {
        for (FluidStack stack : ingredients) {
            if (!stack.getFluid().is(this._tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FluidStack getMatchFrom(FluidStack stack) {
        return this.test(stack) ? stack.copyWithAmount(this._amount) : FluidStack.EMPTY;
    }

    @Override
    public long getAmount(FluidStack stack) {
        return this.isCompatible(stack) ? (long)this._amount : 0L;
    }

    @Override
    public List<FluidStack> getMatchingElements() {
        if (null == this._cachedMatchingElements) {
            this._cachedMatchingElements = (List)TagsHelper.FLUIDS.getObjects(this._tag).stream().map(fluid -> new FluidStack(fluid, this._amount)).collect(ImmutableList.toImmutableList());
        }
        return this._cachedMatchingElements;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean test(FluidStack stack) {
        return this.isCompatible(stack) && stack.getAmount() >= this._amount;
    }

    @Override
    public boolean testIgnoreAmount(FluidStack stack) {
        return this.isCompatible(stack);
    }

    public String toString() {
        return this._amount + 32 + this._tag.toString();
    }

    protected FluidStackRecipeIngredientTag(TagKey<Fluid> tag, int amount) {
        this._tag = tag;
        this._amount = amount;
    }
}

