/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.modify.AugmentModifier;
import com.blakebr0.mysticalcustomization.util.ErrorManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;

public final class AugmentLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY = "Augment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterAugments(IAugmentRegistry registry) {
        block16: {
            File file;
            block17: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-augments.json").toFile()).exists() || !file.isFile()) break block17;
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : json.entrySet()) {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        Augment augment = registry.getAugmentById(ResourceLocation.tryParse((String)id));
                        try {
                            if (augment == null) {
                                throw new JsonSyntaxException("Unknown augment id: %s".formatted(id));
                            }
                            AugmentModifier.modify(augment, changes);
                        }
                        catch (JsonSyntaxException | ResourceLocationException e) {
                            ErrorManager.INSTANCE.addError(CATEGORY, "Modifying %s: %s".formatted(id, e.getMessage()));
                        }
                    }
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        ErrorManager.INSTANCE.addFatalError(CATEGORY, "An error occurred while reading configure-augments.json.", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block16;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block16;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                MysticalCustomization.LOGGER.error("An error occurred while creating configure-augment.json", (Throwable)e);
            }
        }
    }
}

