/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block.entity;

import java.util.Optional;
import java.util.stream.IntStream;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBotanyPotBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public static final int SOIL_SLOT = 0;
    public static final int SEED_SLOT = 1;
    public static final int TOOL_SLOT = 2;
    public static final int SLOT_COUNT = 15;
    public static final int[] STORAGE_SLOTS = IntStream.range(3, 15).toArray();
    public static final int[] EMPTY_SLOTS = new int[0];
    public static final Component DEFAULT_NAME = Component.translatable((String)"container.botanypots.botany_pot");
    private NonNullList<ItemStack> items = NonNullList.withSize((int)15, (Object)ItemStack.EMPTY);
    protected CachedSupplier<BlockPos> below = CachedSupplier.cache(() -> this.getBlockPos().below());
    protected CachedSupplier<PotType> potType = CachedSupplier.cache(() -> ((BotanyPotBlock)this.getBlockState().getBlock()).type);

    public abstract void onSoilChanged(ItemStack var1);

    public abstract void onSeedChanged(ItemStack var1);

    public abstract void onToolChanged(ItemStack var1);

    protected AbstractBotanyPotBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public PotType getPotType() {
        return (PotType)((Object)this.potType.get());
    }

    public boolean isHopper() {
        return this.potType.get() == PotType.HOPPER;
    }

    public ItemStack getSoilItem() {
        return (ItemStack)this.items.get(0);
    }

    public void setSoilItem(ItemStack newSoil) {
        this.setItem(0, newSoil);
    }

    public ItemStack getSeedItem() {
        return (ItemStack)this.items.get(1);
    }

    public void setSeed(ItemStack newSeed) {
        this.setItem(1, newSeed);
    }

    public ItemStack getHarvestItem() {
        return this.getItem(2);
    }

    public void setHoe(ItemStack hoeStack) {
        this.setItem(2, hoeStack);
    }

    public void runFunction(ResourceLocation functionId) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional function = serverLevel.getServer().getFunctions().get(functionId);
            CommandSourceStack sourceStack = this.createCommandSourceStack();
            if (sourceStack != null) {
                function.ifPresentOrElse(func -> serverLevel.getServer().getFunctions().execute(func, sourceStack), () -> BotanyPotsMod.LOG.error("Pot at {} tried to run missing function {}. This is an issue with your datapacks.", (Object)this.worldPosition, (Object)functionId));
            }
        }
    }

    @Nullable
    public CommandSourceStack createCommandSourceStack() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Component name = this.getName();
            return new CommandSourceStack(CommandSource.NULL, Vec3.atCenterOf((Vec3i)this.worldPosition), new Vec2(0.0f, direction.toYRot()), serverLevel, 2, name.getString(), name, serverLevel.getServer(), null);
        }
        return null;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setItem(int slotId, @NotNull ItemStack stack) {
        super.setItem(slotId, stack);
        if (slotId == 0) {
            this.onSoilChanged(stack);
        } else if (slotId == 1) {
            this.onSeedChanged(stack);
        } else if (slotId == 2) {
            this.onToolChanged(stack);
        }
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        return side == Direction.DOWN ? STORAGE_SLOTS : EMPTY_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction side) {
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction side) {
        return side == Direction.DOWN && this.isHopper() && slot > 2 && slot < 15;
    }

    @NotNull
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> newItems) {
        this.items = newItems;
    }

    public int getContainerSize() {
        return 15;
    }
}

