/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;

public class ColoredPumpkinBlock
extends PumpkinBlock {
    public ColoredPumpkinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!stack.canPerformAction(ItemAbilities.SHEARS_CARVE)) {
            return super.useItemOn(stack, state, level, pos, player, hand, blockHitResult);
        }
        if (!level.isClientSide) {
            Direction direction = blockHitResult.getDirection();
            Direction direction1 = direction.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : direction;
            level.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)((Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getKey((Object)this).withPath(p -> p.replace("pumpkin", "carved_pumpkin")))).defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)direction1), 11);
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)direction1.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction1.getStepZ() * 0.65, new ItemStack((ItemLike)Items.PUMPKIN_SEEDS, 4));
            itementity.setDeltaMovement(0.05 * (double)direction1.getStepX() + level.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.getStepZ() + level.random.nextDouble() * 0.02);
            level.addFreshEntity((Entity)itementity);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
        }
        return ItemInteractionResult.sidedSuccess((boolean)true);
    }
}

