/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.hud;

import codechicken.lib.gui.modular.elements.GuiContextMenu;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.math.Vector2;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public abstract class AbstractHudElement {
    protected Vector2 rawPos;
    protected double width = 100.0;
    protected double height = 20.0;
    protected boolean enabled = true;
    protected double dragXOffset = 0.0;
    protected double dragYOffset = 0.0;
    private Runnable changeListener = null;

    public AbstractHudElement(Vector2 defaultRawPos) {
        this.rawPos = defaultRawPos;
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public abstract void tick(boolean var1);

    public abstract void render(GuiRender var1, float var2, boolean var3);

    public boolean shouldRender(boolean preRenderEvent) {
        return preRenderEvent;
    }

    public void addConfigElements(GuiContextMenu menu) {
        menu.addOption(() -> Component.translatable((String)("gui.brandonscore.hud_config.enabled." + this.enabled)), this.runDirty(() -> {
            this.enabled = !this.enabled;
        }));
    }

    public GuiContextMenu createConfigDialog(GuiElement<?> parentElement) {
        GuiContextMenu dialog = GuiContextMenu.tooltipStyleMenu(parentElement);
        this.addConfigElements(dialog);
        return dialog;
    }

    protected Runnable runDirty(Runnable run) {
        return () -> {
            run.run();
            this.markDirty();
        };
    }

    public double xPos() {
        int screen = this.screenWidth();
        double pos = (double)screen * this.rawPos.x;
        return (int)(pos -= this.width() * this.rawPos.x);
    }

    public double yPos() {
        int screen = this.screenHeight();
        double pos = (double)screen * this.rawPos.y;
        return (int)(pos -= this.height() * this.rawPos.y);
    }

    public int screenWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth();
    }

    public int screenHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight();
    }

    public void writeNBT(CompoundTag nbt) {
        nbt.putBoolean("enabled", this.enabled);
        nbt.putDouble("pos_x", this.rawPos.x);
        nbt.putDouble("pos_y", this.rawPos.y);
    }

    public void readNBT(CompoundTag nbt) {
        this.enabled = nbt.getBoolean("enabled");
        this.rawPos.x = nbt.getDouble("pos_x");
        this.rawPos.y = nbt.getDouble("pos_y");
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void markDirty() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void startMoving(double mouseX, double mouseY) {
        this.dragXOffset = (double)((int)mouseX) - this.xPos();
        this.dragYOffset = (double)((int)mouseY) - this.yPos();
    }

    public void onDragged(double mouseX, double mouseY) {
        double xMove = (int)(mouseX - this.dragXOffset - this.xPos());
        double yMove = (int)(mouseY - this.dragYOffset - this.yPos());
        this.rawPos.x = Mth.clamp((double)(this.rawPos.x + xMove / (double)this.screenWidth()), (double)0.0, (double)1.0);
        this.rawPos.y = Mth.clamp((double)(this.rawPos.y + yMove / (double)this.screenHeight()), (double)0.0, (double)1.0);
    }

    public void stopMoving() {
        this.markDirty();
    }

    public AbstractHudElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

