/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.lib.IValueHashable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class SerializationFlags<D extends INBTSerializable<CompoundTag>> {
    protected final String tagName;
    protected final D serializableInstance;
    protected Object lastData;
    protected boolean saveTile = false;
    protected boolean saveItem = false;
    protected boolean syncTile = false;
    protected boolean syncContainer = false;

    public SerializationFlags(String tagName, D serializableInstance) {
        this.tagName = tagName;
        this.serializableInstance = serializableInstance;
        if (serializableInstance instanceof IValueHashable) {
            IValueHashable hashable = (IValueHashable)serializableInstance;
            this.lastData = hashable.getValueHash();
            this.syncContainer = true;
        }
    }

    public void lazyLoadDefault(HolderLookup.Provider provider) {
        if (this.lastData == null) {
            this.lastData = this.serializableInstance.serializeNBT(provider);
        }
    }

    public D getData() {
        return this.serializableInstance;
    }

    public SerializationFlags<D> saveItem() {
        this.saveItem = true;
        return this;
    }

    public SerializationFlags<D> saveTile() {
        this.saveTile = true;
        return this;
    }

    public SerializationFlags<D> saveBoth() {
        this.saveItem();
        this.saveTile();
        return this;
    }

    public SerializationFlags<D> syncTile() {
        this.syncTile = true;
        return this;
    }

    public SerializationFlags<D> syncContainer() {
        this.syncContainer = true;
        return this;
    }

    protected boolean hasChanged(boolean reset, HolderLookup.Provider provider) {
        D d = this.serializableInstance;
        if (d instanceof IValueHashable) {
            IValueHashable hashable = (IValueHashable)d;
            if (!hashable.checkValueHash(this.lastData)) {
                if (reset) {
                    this.lastData = hashable.getValueHash();
                }
                return true;
            }
        } else if (!((CompoundTag)this.serializableInstance.serializeNBT(provider)).equals(this.lastData)) {
            if (reset) {
                this.lastData = this.serializableInstance.serializeNBT(provider);
            }
            return true;
        }
        return false;
    }
}

