/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.model;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.model.ContributorModel;
import com.brandon3055.brandonscore.client.render.EquippedItemModel;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.items.EquippedModelItem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;

public class EquippedItemModelLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private boolean slimModel;
    private ContributorModel<?> contributorModel = new ContributorModel();

    public EquippedItemModelLayer(LivingEntityRenderer<T, M> renderer, boolean slimModel) {
        super(renderer);
        this.slimModel = slimModel;
    }

    public void render(PoseStack mStack, MultiBufferSource getter, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Player player;
        ContributorProperties props;
        ItemStack stack;
        this.renderItemModel(mStack, getter, livingEntity, livingEntity.getItemBySlot(EquipmentSlot.CHEST), EquipmentSlot.CHEST, packedLightIn, partialTicks);
        this.renderItemModel(mStack, getter, livingEntity, livingEntity.getItemBySlot(EquipmentSlot.LEGS), EquipmentSlot.LEGS, packedLightIn, partialTicks);
        this.renderItemModel(mStack, getter, livingEntity, livingEntity.getItemBySlot(EquipmentSlot.FEET), EquipmentSlot.FEET, packedLightIn, partialTicks);
        this.renderItemModel(mStack, getter, livingEntity, livingEntity.getItemBySlot(EquipmentSlot.HEAD), EquipmentSlot.HEAD, packedLightIn, partialTicks);
        if (BrandonsCore.equipmentManager != null && !(stack = BrandonsCore.equipmentManager.findMatchingItem(e -> e.getItem() instanceof EquippedModelItem, (LivingEntity)livingEntity)).isEmpty()) {
            this.renderItemModel(mStack, getter, livingEntity, stack, null, packedLightIn, partialTicks);
        }
        if (livingEntity instanceof Player && (props = ContributorHandler.getProps(player = (Player)livingEntity)).isContributor()) {
            ClientHooks.copyModelProperties((HumanoidModel)((HumanoidModel)this.getParentModel()), this.contributorModel);
            this.contributorModel.props = props;
            this.contributorModel.render((LivingEntity)livingEntity, mStack, getter, ItemStack.EMPTY, packedLightIn, OverlayTexture.NO_OVERLAY, partialTicks);
        }
    }

    private void renderItemModel(PoseStack poseStack, MultiBufferSource source, T entity, ItemStack stack, @Nullable EquipmentSlot slot, int packedlight, float partialTicks) {
        Item item = stack.getItem();
        if (item instanceof EquippedModelItem) {
            ArmorItem armorItem;
            Item item2;
            EquippedModelItem modelItem = (EquippedModelItem)item;
            if (slot != null && (item2 = stack.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)item2).getEquipmentSlot() != slot) {
                return;
            }
            EquippedItemModel model = modelItem.getExtendedModel((LivingEntity)entity, stack, slot, (HumanoidModel<?>)((HumanoidModel)this.getParentModel()), this.slimModel);
            model.render((LivingEntity)entity, poseStack, source, stack, packedlight, OverlayTexture.NO_OVERLAY, partialTicks);
        }
    }
}

