/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemHandlerSlotWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable wrapped;
    private final int[] slots;

    public ItemHandlerSlotWrapper(IItemHandlerModifiable wrapped, int[] slots) {
        this.wrapped = wrapped;
        this.slots = slots;
    }

    public ItemHandlerSlotWrapper(IItemHandlerModifiable wrapped, int fslot, int lslot) {
        this.wrapped = wrapped;
        this.slots = new int[lslot - fslot];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = fslot + i;
        }
    }

    public int getSlots() {
        return this.slots.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.wrapped.getStackInSlot(this.slots[slot]);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.wrapped.insertItem(this.slots[slot], stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.wrapped.extractItem(this.slots[slot], amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.checkSlot(slot)) {
            this.wrapped.setStackInSlot(this.slots[slot], stack);
        }
    }

    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.wrapped.getSlotLimit(this.slots[slot]);
        }
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.checkSlot(slot)) {
            return this.wrapped.isItemValid(this.slots[slot], stack);
        }
        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot < this.slots.length;
    }
}

