/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.lib.DLResource;
import com.brandon3055.brandonscore.lib.ThreadedImageDownloader;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;

@Deprecated
public class DLRSCache {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final DLResource DOWNLOADING_TEXTURE = new DLResource("brandonscore", "textures/loading_texture.png");
    private static Map<String, DLResource> resourceCache;
    private static File cacheFolder;
    private static Pattern urlStripper;

    public static void init() {
        LOCK.lock();
        cacheFolder = new File(FileHandler.brandon3055Folder, "ResourceCache");
        cacheFolder.mkdirs();
    }

    public static DLResource getResource(String url) {
        String key = urlStripper.matcher(url).replaceAll("_").toLowerCase(Locale.ENGLISH);
        if (!resourceCache.containsKey(key)) {
            DLResource resourceLocation = new DLResource("brandonscore", key);
            TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
            File cache = new File(cacheFolder, "Cache#" + url.hashCode() + ".png");
            ThreadedImageDownloader downloader = new ThreadedImageDownloader(cache, url, DOWNLOADING_TEXTURE);
            downloader.setDlLocation(resourceLocation);
            texturemanager.register(resourceLocation.resource, (AbstractTexture)downloader);
            resourceCache.put(key, resourceLocation);
        }
        return resourceCache.get(key);
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static void clearFileCache() {
        DLRSCache.clearResourceCache();
        File[] files = cacheFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("Cache#")) continue;
                file.delete();
            }
        }
    }

    public static void clearResourceCache(String url) {
        String key = urlStripper.matcher(url).replaceAll("_").toLowerCase(Locale.ENGLISH);
        resourceCache.remove(key);
    }

    public static void clearFileCache(String url) {
        DLRSCache.clearResourceCache(url);
        File[] files = cacheFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals("Cache#" + url.hashCode() + ".png")) continue;
                file.delete();
                return;
            }
        }
    }

    static {
        DLRSCache.DOWNLOADING_TEXTURE.height = 16;
        DLRSCache.DOWNLOADING_TEXTURE.width = 16;
        DLRSCache.DOWNLOADING_TEXTURE.sizeSet = true;
        resourceCache = new HashMap<String, DLResource>();
        urlStripper = Pattern.compile("([^a-zA-Z0-9]*)");
    }
}

