/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class StringyStacks {
    public static final Logger LOGGER = LogManager.getLogger((String)"StackConverter");

    public static ItemStack fromString(String stackString, HolderLookup.Provider provider) {
        return StringyStacks.fromString(stackString, ItemStack.EMPTY, provider);
    }

    public static ItemStack fromString(String stackString, @Nullable ItemStack defaultIfInputInvalid, HolderLookup.Provider provider) {
        ItemStack stack;
        if (stackString.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!stackString.contains(":")) {
            LOGGER.warn("StackReference: Was given an invalid stack string. String did not contain \":\" - " + stackString);
            return defaultIfInputInvalid;
        }
        if (stackString.contains("{") && stackString.contains(",") && stackString.indexOf(",") < stackString.indexOf("{")) {
            try {
                return StringyStacks.legacyFromString(stackString, defaultIfInputInvalid);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse legacy stack string - " + stackString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        String stackStr = stackString;
        String itemID = stackStr.contains("{") ? stackStr.substring(0, stackStr.indexOf("{")) : (stackStr.contains(",") ? stackStr.substring(0, stackStr.indexOf(",")) : stackStr);
        stackStr = stackString.substring(itemID.length());
        CompoundTag tagNBT = null;
        if (stackStr.startsWith("{")) {
            if (!stackString.contains("}") || stackStr.lastIndexOf("}") < stackString.indexOf("{")) {
                LOGGER.warn("Detected invalid NBT definition on stack string - " + stackString);
                return defaultIfInputInvalid;
            }
            String tag = stackStr.substring(0, stackStr.lastIndexOf("}") + 1);
            try {
                tagNBT = TagParser.parseTag((String)tag);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + tag + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
            stackStr = stackString.substring(tag.length());
        }
        int count = 1;
        if (stackStr.startsWith(",") && stackString.length() > 1) {
            try {
                count = Integer.parseInt(stackStr.substring(1));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + stackStr + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        CompoundTag stackNBT = new CompoundTag();
        stackNBT.putString("id", itemID);
        stackNBT.putByte("Count", (byte)count);
        if (tagNBT != null && !tagNBT.isEmpty()) {
            if (tagNBT.size() == 2 && tagNBT.contains("tag", 10) && tagNBT.contains("ForgeCaps")) {
                CompoundTag caps;
                CompoundTag tag = tagNBT.getCompound("tag");
                if (!tag.isEmpty()) {
                    stackNBT.put("tag", (Tag)tag);
                }
                if (!(caps = tagNBT.getCompound("ForgeCaps")).isEmpty()) {
                    stackNBT.put("ForgeCaps", (Tag)caps);
                }
            } else {
                stackNBT.put("tag", (Tag)tagNBT);
            }
        }
        if ((stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)stackNBT)) == ItemStack.EMPTY) {
            return defaultIfInputInvalid;
        }
        return stack;
    }

    private static ItemStack legacyFromString(String string, @Nullable ItemStack defaultIfInputInvalid) {
        String stackString;
        String workString = string;
        String splitter = ",";
        String countString = "";
        String metaString = "";
        String nbt = "";
        if (!workString.contains(splitter)) {
            stackString = workString;
            workString = "";
        } else {
            stackString = workString.substring(0, workString.indexOf(splitter));
            workString = workString.substring(workString.indexOf(splitter) + splitter.length());
        }
        if (!workString.isEmpty()) {
            if (!workString.contains(splitter)) {
                countString = workString;
                workString = "";
            } else {
                countString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (!workString.isEmpty()) {
            if (!workString.contains(splitter)) {
                metaString = workString;
                workString = "";
            } else {
                metaString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (!workString.isEmpty()) {
            nbt = workString;
        }
        int count = 1;
        int meta = 0;
        CompoundTag compound = null;
        if (!countString.isEmpty()) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + countString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (!metaString.isEmpty()) {
            try {
                meta = Integer.parseInt(metaString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack meta from string - " + metaString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (!nbt.isEmpty()) {
            try {
                compound = TagParser.parseTag((String)nbt);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + nbt + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        ResourceLocation registryName = ResourceLocation.parse((String)stackString);
        Item item = (Item)BuiltInRegistries.ITEM.get(registryName);
        Block block = (Block)BuiltInRegistries.BLOCK.get(registryName);
        if (item == Items.AIR && block == Blocks.AIR) {
            return defaultIfInputInvalid;
        }
        ItemStack itemStack = item != Items.AIR ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)block, count);
        itemStack.setDamageValue(meta);
        if (compound != null) {
            // empty if block
        }
        return itemStack;
    }

    public static String toString(ItemStack stack, boolean withNBT, boolean withCount, boolean withForgeCaps, HolderLookup.Provider provider) {
        if (stack.isEmpty()) {
            return "";
        }
        Object stackString = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (withNBT || withForgeCaps) {
            CompoundTag stackTag = (CompoundTag)stack.saveOptional(provider);
            CompoundTag nbt = null;
            CompoundTag caps = null;
            if (withNBT && stackTag.contains("tag", 10)) {
                nbt = stackTag.getCompound("tag");
            }
            if (withForgeCaps && stackTag.contains("ForgeCaps")) {
                caps = stackTag.getCompound("ForgeCaps");
            }
            CompoundTag stringTag = null;
            if (nbt != null && caps == null) {
                stringTag = nbt;
            } else if (caps != null) {
                stringTag = new CompoundTag();
                stringTag.put("ForgeCaps", (Tag)caps);
                stringTag.put("tag", (Tag)(nbt == null ? new CompoundTag() : nbt));
            }
            if (stringTag != null && !stringTag.isEmpty()) {
                stackString = (String)stackString + stringTag.toString();
            }
        }
        if (withCount && stack.getCount() > 1) {
            stackString = (String)stackString + "," + stack.getCount();
        }
        return stackString;
    }

    public static String toStringNoCaps(ItemStack stack, HolderLookup.Provider provider) {
        return StringyStacks.toString(stack, true, true, false, provider);
    }

    public static String toString(ItemStack stack, HolderLookup.Provider provider) {
        return StringyStacks.toString(stack, true, true, true, provider);
    }

    @Deprecated
    public static ItemStack legacyStackConverter(String itemString, int count, int damage, @Nullable CompoundTag nbt) {
        try {
            ResourceLocation itemID = ResourceLocation.parse((String)itemString);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemID);
            Block block = (Block)BuiltInRegistries.BLOCK.get(itemID);
            if (item == Items.AIR && block == Blocks.AIR) {
                return ItemStack.EMPTY;
            }
            ItemStack itemStack = item != Items.AIR ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)block, count);
            itemStack.setDamageValue(damage);
            if (nbt != null) {
                // empty if block
            }
            return itemStack;
        }
        catch (Throwable e) {
            return ItemStack.EMPTY;
        }
    }
}

