/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.util.thread.EffectiveSide;

public class EntityFilter
extends FilterGroup {
    private boolean livingOnly = false;
    private List<FilterType> allowedFilters = new ArrayList<FilterType>();
    private List<FilterBase> fixedFilters = new ArrayList<FilterBase>();
    public Int2ObjectMap<FilterBase> nodeMap = new Int2ObjectOpenHashMap();
    private Predicate<FilterType> typePredicate;
    private int nextNodeID = 1;
    private Supplier<PacketCustom> serverPacketProvider;
    private Consumer<PacketCustom> serverPacketSender;
    private Supplier<PacketCustom> clientPacketProvider;
    private Runnable dirtyHandler;
    private com.google.common.base.Predicate<Entity> filterPredicate = this::test;
    public boolean fixedAndLogic = false;
    public int maxFilters = 256;

    public EntityFilter(boolean livingOnly, FilterType ... allowedFilters) {
        super(null);
        this.livingOnly = livingOnly;
        this.allowedFilters.addAll(Arrays.asList(allowedFilters));
        this.andGroup = true;
        this.nodeID = 0;
        this.trackNode(this);
    }

    public boolean isLivingOnly() {
        return this.livingOnly;
    }

    public void syncClient(ServerPlayer player) {
        PacketCustom output = this.serverPacketProvider.get();
        output.writeByte(0);
        this.serializeMCD((MCDataOutput)output);
        output.sendToPlayer(player);
    }

    public void setupServerPacketHandling(Supplier<PacketCustom> serverPacketProvider, Consumer<PacketCustom> serverPacketSender) {
        this.serverPacketProvider = serverPacketProvider;
        this.serverPacketSender = serverPacketSender;
    }

    public void receivePacketFromServer(MCDataInput input) {
        int nodeID;
        FilterBase node;
        byte id = input.readByte();
        if (id == 0) {
            this.deSerializeMCD(input);
        } else if (id == 1 && (node = (FilterBase)this.nodeMap.get(nodeID = input.readVarInt())) != null) {
            node.deSerializeMCD(input);
        }
    }

    protected void filterChanged() {
        if (this.serverPacketProvider != null && EffectiveSide.get().isServer()) {
            PacketCustom output = this.serverPacketProvider.get();
            output.writeByte(0);
            this.serializeMCD((MCDataOutput)output);
            this.serverPacketSender.accept(output);
        }
    }

    private void serverModifiedNode(FilterBase node) {
        if (this.serverPacketProvider != null && EffectiveSide.get().isServer()) {
            PacketCustom output = this.serverPacketProvider.get();
            output.writeByte(1);
            output.writeVarInt(node.nodeID);
            node.serializeMCD((MCDataOutput)output);
            this.serverPacketSender.accept(output);
        }
    }

    public void setupClientPacketHandling(Supplier<PacketCustom> clientPacketProvider) {
        this.clientPacketProvider = clientPacketProvider;
    }

    public void receivePacketFromClient(MCDataInput input) {
        byte id = input.readByte();
        if (id == 0) {
            FilterType type = (FilterType)input.readEnum(FilterType.class);
            int parentID = input.readVarInt();
            FilterBase parent = (FilterBase)this.nodeMap.get(parentID);
            if (parent instanceof FilterGroup && this.nodeMap.size() <= this.maxFilters) {
                ((FilterGroup)parent).addNode(type.createNode(this));
            }
        } else if (id == 1) {
            int nodeID = input.readVarInt();
            FilterBase node = (FilterBase)this.nodeMap.get(nodeID);
            if (node != null && node != this && node.getParent() != null) {
                node.getParent().removeNode(node);
            }
        } else if (id == 2) {
            int nodeID = input.readVarInt();
            FilterBase node = (FilterBase)this.nodeMap.get(nodeID);
            if (node != null) {
                node.deSerializeMCD(input);
                this.serverModifiedNode(node);
            }
        } else if (id == 3) {
            this.nodeMap.clear();
            this.subNodeMap.clear();
            this.trackNode(this);
            this.filterChanged();
        }
        this.markDirty();
    }

    public void clientAddNode(FilterType type, FilterGroup parentGroup) {
        if (parentGroup == null) {
            return;
        }
        PacketCustom output = this.clientPacketProvider.get();
        output.writeByte(0);
        output.writeEnum((Enum)type);
        output.writeVarInt(parentGroup.nodeID);
        output.sendToServer();
    }

    public void clientRemoveNode(int nodeID) {
        PacketCustom output = this.clientPacketProvider.get();
        output.writeByte(1);
        output.writeVarInt(nodeID);
        output.sendToServer();
    }

    public void clientClearFilter() {
        PacketCustom output = this.clientPacketProvider.get();
        output.writeByte(3);
        output.sendToServer();
    }

    private void clientModifiedNode(FilterBase node) {
        if (this.clientPacketProvider != null) {
            PacketCustom output = this.clientPacketProvider.get();
            output.writeByte(2);
            output.writeVarInt(node.nodeID);
            node.serializeMCD((MCDataOutput)output);
            output.sendToServer();
        }
    }

    public void nodeModified(FilterBase node) {
        if (EffectiveSide.get().isClient()) {
            this.clientModifiedNode(node);
        } else {
            this.serverModifiedNode(node);
        }
    }

    public void setTypePredicate(Predicate<FilterType> typePredicate) {
        this.typePredicate = typePredicate;
    }

    public boolean isFilterAllowed(FilterType type) {
        return this.allowedFilters.contains((Object)type) && (this.typePredicate == null || this.typePredicate.test(type));
    }

    public List<FilterBase> getFixedFilters() {
        return this.fixedFilters;
    }

    public List<Entity> filterEntities(Collection<Entity> entities) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        entities.stream().filter(this::test).forEach(list::add);
        return list;
    }

    public void filterEntityCollection(Collection<Entity> entities) {
        entities.removeIf(entity -> !this.test((Entity)entity));
    }

    public Stream<Entity> toFilteredStream(Collection<Entity> entities) {
        return entities.stream().filter(this::test);
    }

    @Override
    public boolean test(Entity entity) {
        if (this.livingOnly && !(entity instanceof LivingEntity)) {
            return false;
        }
        boolean fixedPass = this.fixedAndLogic ? this.fixedFilters.isEmpty() || this.fixedFilters.parallelStream().allMatch(node -> node.test(entity)) : this.fixedFilters.isEmpty() || this.fixedFilters.parallelStream().anyMatch(node -> node.test(entity));
        return super.test(entity) && fixedPass;
    }

    public Predicate<Entity> predicate() {
        return this.filterPredicate;
    }

    @Override
    public EntityFilter getFilter() {
        return this;
    }

    protected int getNextNodeID() {
        return this.nextNodeID++;
    }

    public void trackNode(FilterBase node) {
        if (node.nodeID == 0 && node != this) {
            return;
        }
        this.nodeMap.put(node.nodeID, (Object)node);
    }

    public void dropNode(FilterBase node) {
        this.nodeMap.remove(node.nodeID);
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        output.writeBoolean(this.fixedAndLogic);
        output.writeVarInt(this.allowedFilters.size());
        if (!this.allowedFilters.isEmpty()) {
            this.allowedFilters.forEach(type -> output.writeByte(type.index));
        }
        super.serializeMCD(output);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        this.fixedAndLogic = input.readBoolean();
        this.nodeMap.clear();
        this.trackNode(this);
        boolean isClient = EffectiveSide.get().isClient();
        if (isClient) {
            this.allowedFilters.clear();
        }
        int allowedCount = input.readVarInt();
        for (int i = 0; i < allowedCount; ++i) {
            FilterType type = FilterType.filterTypeMap[input.readByte()];
            if (!isClient) continue;
            this.allowedFilters.add(type);
        }
        super.deSerializeMCD(input);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.nodeMap.clear();
        super.deserializeNBT(provider, nbt);
        this.trackNode(this);
        this.nextNodeID = this.nodeMap.keySet().stream().mapToInt(value -> value).max().orElse(0) + 1;
    }

    protected void markDirty() {
        if (this.dirtyHandler != null) {
            this.dirtyHandler.run();
        }
    }

    public void setDirtyHandler(Runnable dirtyHandler) {
        this.dirtyHandler = dirtyHandler;
    }

    @Override
    public String getTranslationKey() {
        return "mod_gui.brandonscore.entity_filter";
    }

    public FilterBase getNode(int nodeID) {
        return (FilterBase)this.nodeMap.get(nodeID);
    }
}

