/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.multiblock;

import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.brandonscore.multiblock.StructurePart;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TagPart
implements MultiBlockPart {
    private TagKey<Block> tag;
    private List<Block> blockCache;

    public TagPart(TagKey<Block> tag) {
        this.tag = tag;
    }

    @Override
    public boolean isMatch(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof StructurePart) {
            return ((StructurePart)state.getBlock()).is(level, pos, this.tag);
        }
        return state.is(this.tag);
    }

    @Override
    public Collection<Block> validBlocks() {
        if (this.blockCache == null) {
            this.blockCache = BuiltInRegistries.BLOCK.stream().filter(block -> block.defaultBlockState().is(this.tag)).collect(Collectors.toList());
        }
        return this.blockCache;
    }
}

