/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class FacingUtils {
    public static final BlockPos[] AROUND_X = new BlockPos[]{new BlockPos(0, 1, -1), new BlockPos(0, 1, 0), new BlockPos(0, 1, 1), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, -1, -1), new BlockPos(0, -1, 0), new BlockPos(0, -1, 1)};
    public static final BlockPos[] AROUND_Y = new BlockPos[]{new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1)};
    public static final BlockPos[] AROUND_Z = new BlockPos[]{new BlockPos(1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-1, 1, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-1, -1, 0)};
    public static final BlockPos[] AROUND_ALL;
    public static final Direction[] FACES_AROUND_X;
    public static final Direction[] FACES_AROUND_Y;
    public static final Direction[] FACES_AROUND_Z;

    public static BlockPos[] getAroundAxis(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return AROUND_X;
        }
        if (axis == Direction.Axis.Y) {
            return AROUND_Y;
        }
        return AROUND_Z;
    }

    public static Direction[] getAxisFaces(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new Direction[]{Direction.EAST, Direction.WEST};
            }
            case Y: {
                return new Direction[]{Direction.UP, Direction.DOWN};
            }
            case Z: {
                return new Direction[]{Direction.NORTH, Direction.SOUTH};
            }
        }
        return new Direction[0];
    }

    public static Direction[] getFacingsAroundAxis(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return FACES_AROUND_X;
        }
        if (axis == Direction.Axis.Y) {
            return FACES_AROUND_Y;
        }
        return FACES_AROUND_Z;
    }

    public static Direction rotateAround(Direction facing, Direction.Axis axis, boolean reverse) {
        switch (axis) {
            case X: {
                if (facing != Direction.WEST && facing != Direction.EAST) {
                    return FacingUtils.rotateX(facing, reverse);
                }
                return facing;
            }
            case Y: {
                if (facing != Direction.UP && facing != Direction.DOWN) {
                    return FacingUtils.rotateY(facing, reverse);
                }
                return facing;
            }
            case Z: {
                if (facing != Direction.NORTH && facing != Direction.SOUTH) {
                    return FacingUtils.rotateZ(facing, reverse);
                }
                return facing;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + String.valueOf(axis));
    }

    private static Direction rotateY(Direction facing, boolean reverse) {
        switch (facing) {
            case NORTH: {
                return reverse ? Direction.WEST : Direction.EAST;
            }
            case EAST: {
                return reverse ? Direction.NORTH : Direction.SOUTH;
            }
            case SOUTH: {
                return reverse ? Direction.EAST : Direction.WEST;
            }
            case WEST: {
                return reverse ? Direction.SOUTH : Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(facing));
    }

    private static Direction rotateX(Direction facing, boolean reverse) {
        switch (facing) {
            case NORTH: {
                return reverse ? Direction.UP : Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(facing));
            }
            case SOUTH: {
                return reverse ? Direction.DOWN : Direction.UP;
            }
            case UP: {
                return reverse ? Direction.SOUTH : Direction.NORTH;
            }
            case DOWN: 
        }
        return reverse ? Direction.NORTH : Direction.SOUTH;
    }

    private static Direction rotateZ(Direction facing, boolean reverse) {
        switch (facing) {
            case EAST: {
                return reverse ? Direction.UP : Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(facing));
            }
            case WEST: {
                return reverse ? Direction.DOWN : Direction.UP;
            }
            case UP: {
                return reverse ? Direction.WEST : Direction.EAST;
            }
            case DOWN: 
        }
        return reverse ? Direction.EAST : Direction.WEST;
    }

    public static int distanceInDirection(BlockPos fromPos, BlockPos toPos, Direction direction) {
        switch (direction) {
            case DOWN: {
                return fromPos.getY() - toPos.getY();
            }
            case UP: {
                return toPos.getY() - fromPos.getY();
            }
            case NORTH: {
                return fromPos.getZ() - toPos.getZ();
            }
            case SOUTH: {
                return toPos.getZ() - fromPos.getZ();
            }
            case WEST: {
                return fromPos.getX() - toPos.getX();
            }
            case EAST: {
                return toPos.getX() - fromPos.getX();
            }
        }
        return 0;
    }

    public static Direction rotateXYZ(Direction current) {
        switch (current) {
            case DOWN: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.DOWN;
            }
        }
        return Direction.NORTH;
    }

    static {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos pos : AROUND_X) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        for (BlockPos pos : AROUND_Y) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        for (BlockPos pos : AROUND_Z) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        AROUND_ALL = list.toArray(new BlockPos[0]);
        ArrayList<Direction> x = new ArrayList<Direction>();
        ArrayList<Direction> y = new ArrayList<Direction>();
        ArrayList<Direction> z = new ArrayList<Direction>();
        for (Direction facing : Direction.values()) {
            if (facing.getAxis() != Direction.Axis.X) {
                x.add(facing);
            }
            if (facing.getAxis() != Direction.Axis.Y) {
                y.add(facing);
            }
            if (facing.getAxis() == Direction.Axis.Z) continue;
            z.add(facing);
        }
        FACES_AROUND_X = x.toArray(new Direction[1]);
        FACES_AROUND_Y = y.toArray(new Direction[1]);
        FACES_AROUND_Z = z.toArray(new Direction[1]);
    }
}

