/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;

public class CmdInfo
implements Command<CommandSourceStack> {
    private static final CmdInfo CMD = new CmdInfo();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"info").requires(cs -> cs.hasPermission(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos pos = player.blockPosition();
        ServerLevel sw = Tools.getServerWorld((LevelAccessor)player.level());
        ChunkAccess chunk = sw.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.STRUCTURE_REFERENCES, false);
        if (chunk != null) {
            Map references = chunk.getAllReferences();
            for (Structure s : references.keySet()) {
                LongSet longs = (LongSet)references.get(s);
                ResourceLocation key = sw.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)s);
                player.sendSystemMessage((Component)Component.literal((String)(key.toString() + ": " + longs.size())));
            }
        }
        int light = sw.getBrightness(LightLayer.BLOCK, pos);
        int light_sky = sw.getBrightness(LightLayer.SKY, pos);
        int light_full = sw.getMaxLocalRawBrightness(pos);
        player.sendSystemMessage((Component)Component.literal((String)("Light: " + light + ", sky: " + light_sky + ", full: " + light_full)));
        DataStorage data = DataStorage.getData((LevelAccessor)sw);
        player.sendSystemMessage((Component)Component.literal((String)("Current day is " + data.getDaycounter())));
        long time = sw.getDayTime();
        player.sendSystemMessage((Component)Component.literal((String)("Current time is " + time + " (daytime: " + time % 24000L + ")")));
        return 0;
    }
}

