/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.VecHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class GadgetUtils {
    private static final ImmutableList<Property<?>> DENY_PROPERTIES = ImmutableList.of((Object)BlockStateProperties.AGE_1, (Object)BlockStateProperties.AGE_2, (Object)BlockStateProperties.AGE_3, (Object)BlockStateProperties.AGE_4, (Object)BlockStateProperties.AGE_5, (Object)BlockStateProperties.AGE_7, (Object)BlockStateProperties.AGE_15, (Object)BlockStateProperties.AGE_25, (Object)DoublePlantBlock.HALF, (Object)BlockStateProperties.WATERLOGGED, (Object)BlockStateProperties.LIT, (Object)BlockStateProperties.HAS_RECORD, (Object[])new Property[]{BlockStateProperties.HAS_BOOK, BlockStateProperties.OPEN, BlockStateProperties.STAGE});

    public static boolean isValidBlockState(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.is(BG2BlockTags.BG2DENY)) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return blockState.getFluidState().isEmpty() || blockState.getFluidState().isSource();
    }

    public static boolean isValidDestroyBlockState(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.isAir()) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return !(blockState.getBlock() instanceof RenderBlock);
    }

    public static boolean setBlockState(ItemStack gadget, BlockState blockState) {
        BlockState placeState = GadgetUtils.cleanBlockState(blockState);
        GadgetNBT.setGadgetBlockState(gadget, placeState);
        return true;
    }

    public static ItemStack getSimpleItemForBlock(BlockState blockState) {
        return new ItemStack((ItemLike)blockState.getBlock());
    }

    public static ItemStack getItemForBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return blockState.getCloneItemStack((HitResult)new BlockHitResult(Vec3.ZERO, Direction.UP, blockPos, false), (LevelReader)level, blockPos, player);
    }

    public static List<ItemStack> getDropsForBlockState(ServerLevel level, BlockPos blockPos, BlockState blockState, Player player) {
        ItemStack tempStack = new ItemStack((ItemLike)Registration.Exchanging_Gadget.get());
        HolderLookup.RegistryLookup registrylookup = level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        tempStack.enchant((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), 1);
        ArrayList<ItemStack> drops = new ArrayList();
        try {
            drops = new ArrayList<ItemStack>(GadgetUtils.getDropsForBlockStateGadget(level, blockPos, blockState, tempStack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack baseItem = player != null ? GadgetUtils.getItemForBlock(blockState, (Level)level, blockPos, player) : GadgetUtils.getSimpleItemForBlock(blockState);
        if (drops.stream().filter(e -> ItemStack.isSameItem((ItemStack)e, (ItemStack)baseItem)).toList().isEmpty()) {
            drops = new ArrayList();
            if (!baseItem.isEmpty()) {
                drops.add(baseItem);
            }
            return drops;
        }
        return drops;
    }

    public static List<ItemStack> getDropsForBlockStateGadget(ServerLevel level, BlockPos blockPos, BlockState blockState, ItemStack gadget) {
        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.TOOL, (Object)gadget);
        return blockState.getDrops(builder);
    }

    public static BlockState cleanBlockState(BlockState sourceState) {
        BlockState placeState = sourceState.getBlock().defaultBlockState();
        for (Property prop : sourceState.getProperties()) {
            if (DENY_PROPERTIES.contains((Object)prop)) continue;
            placeState = GadgetUtils.applyProperty(placeState, sourceState, prop);
        }
        return placeState;
    }

    public static void addToUndoList(Level level, ItemStack gadget, ArrayList<StatePos> buildList, UUID uuid) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        bg2Data.addToUndoList(uuid, buildList, level);
        GadgetNBT.addToUndoList(gadget, uuid, bg2Data);
    }

    public static void addToUndoList(Level level, ItemStack gadget, ArrayList<StatePos> buildList) {
        GadgetUtils.addToUndoList(level, gadget, buildList, UUID.randomUUID());
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.setValue(prop, from.getValue(prop));
    }

    public static AABB getSquareArea(BlockPos pos, Direction face, int range) {
        switch (face) {
            case UP: 
            case DOWN: {
                return new AABB((double)(pos.getX() - range), (double)pos.getY(), (double)(pos.getZ() - range), (double)(pos.getX() + range), (double)pos.getY(), (double)(pos.getZ() + range));
            }
            case NORTH: 
            case SOUTH: {
                return new AABB((double)(pos.getX() - range), (double)(pos.getY() - range), (double)pos.getZ(), (double)(pos.getX() + range), (double)(pos.getY() + range), (double)pos.getZ());
            }
            case EAST: 
            case WEST: {
                return new AABB((double)pos.getX(), (double)(pos.getY() - range), (double)(pos.getZ() - range), (double)pos.getX(), (double)(pos.getY() + range), (double)(pos.getZ() + range));
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(face));
    }

    public static ArrayList<StatePos> getDestructionArea(Level level, BlockPos pos, Direction face, Player player, ItemStack gadget) {
        int depth = GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.DEPTH.getName());
        if (gadget.isEmpty() || depth == 0 || !player.mayBuild()) {
            return new ArrayList<StatePos>();
        }
        boolean vertical = face.getAxis().isVertical();
        Direction up = vertical ? player.getDirection() : Direction.UP;
        Direction down = up.getOpposite();
        Direction right = vertical ? up.getClockWise() : face.getCounterClockWise();
        Direction left = right.getOpposite();
        BlockPos first = pos.relative(left, GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.LEFT.getName())).relative(up, GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.UP.getName()));
        BlockPos second = pos.relative(right, GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.RIGHT.getName())).relative(down, GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.DOWN.getName())).relative(face.getOpposite(), depth - 1);
        AABB box = VecHelpers.aabbFromBlockPos(first, second);
        ArrayList<StatePos> returnList = new ArrayList<StatePos>();
        BlockPos.betweenClosedStream((AABB)box).map(BlockPos::immutable).forEach(blockPos -> {
            BlockState blockState = level.getBlockState(blockPos);
            if (!level.isClientSide) {
                if (!level.mayInteract(player, blockPos)) {
                    return;
                }
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, blockPos, level.getBlockState(blockPos), player);
                if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                    return;
                }
            }
            if (blockState.hasBlockEntity() && !GadgetNBT.getSetting(gadget, GadgetNBT.ToggleableSettings.AFFECT_TILES.getName())) {
                return;
            }
            if (GadgetUtils.isValidDestroyBlockState(blockState, level, blockPos)) {
                returnList.add(new StatePos(blockState, (BlockPos)blockPos));
            }
        });
        return returnList;
    }

    public static boolean direContains(AABB aabb, double x, double y, double z) {
        return x >= aabb.minX && x <= aabb.maxX && y >= aabb.minY && y <= aabb.maxY && z >= aabb.minZ && z <= aabb.maxZ;
    }

    public static boolean direContains(AABB aabb, BlockPos pos) {
        return GadgetUtils.direContains(aabb, pos.getX(), pos.getY(), pos.getZ());
    }
}

