/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={JigsawReplacementProcessor.class})
public abstract class JigsawReplacementProcessorMixin {
    @ModifyReturnValue(method={"processBlock(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;)Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;"}, at={@At(value="RETURN")})
    private StructureTemplate.StructureBlockInfo ml$processSpawnBoxes(@Nullable StructureTemplate.StructureBlockInfo original, LevelReader level, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        if (original != null && original.state().is((Block)MoonlightRegistry.SPAWN_BOX_BLOCK.get())) {
            BlockState blockState2;
            if (original.nbt() == null) {
                Moonlight.LOGGER.warn("Spawn Box block at {} is missing nbt, will not replace", (Object)offset);
                return original;
            }
            String string = original.nbt().getString("final_state");
            try {
                BlockStateParser.BlockResult blockResult = BlockStateParser.parseForBlock((HolderLookup)level.holderLookup(Registries.BLOCK), (String)string, (boolean)true);
                blockState2 = blockResult.blockState();
            }
            catch (CommandSyntaxException var11) {
                Moonlight.LOGGER.error("Failed to parse spawn box replacement state '{}' at {}: {}", (Object)string, (Object)offset, (Object)var11.getMessage());
                return null;
            }
            return blockState2.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(original.pos(), blockState2, null);
        }
        return original;
    }
}

