/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.RankConditionFactory;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RegisterConditionsEvent;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.AndCondition;
import dev.ftb.mods.ftbranks.impl.condition.CreativeModeCondition;
import dev.ftb.mods.ftbranks.impl.condition.DimensionCondition;
import dev.ftb.mods.ftbranks.impl.condition.FakePlayerCondition;
import dev.ftb.mods.ftbranks.impl.condition.NotCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import dev.ftb.mods.ftbranks.impl.condition.OrCondition;
import dev.ftb.mods.ftbranks.impl.condition.PlaytimeCondition;
import dev.ftb.mods.ftbranks.impl.condition.RankAddedCondition;
import dev.ftb.mods.ftbranks.impl.condition.RankAppliesCondition;
import dev.ftb.mods.ftbranks.impl.condition.SpawnCondition;
import dev.ftb.mods.ftbranks.impl.condition.StatCondition;
import dev.ftb.mods.ftbranks.impl.condition.XorCondition;
import dev.ftb.mods.ftbranks.impl.permission.BooleanPermissionValue;
import dev.ftb.mods.ftbranks.impl.permission.NumberPermissionValue;
import dev.ftb.mods.ftbranks.impl.permission.StringPermissionValue;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.math.NumberUtils;

public class FTBRanksAPIImpl
extends FTBRanksAPI {
    public static RankManagerImpl manager;

    @Override
    protected RankManager getManager() {
        return manager;
    }

    @Override
    public PermissionValue parsePermissionValue(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return StringPermissionValue.of(str.substring(1, str.length() - 1));
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return BooleanPermissionValue.of(str.equalsIgnoreCase("true"));
        }
        if (NumberUtils.isCreatable((String)str)) {
            return NumberPermissionValue.of(NumberUtils.createNumber((String)str));
        }
        return StringPermissionValue.of(str);
    }

    public static void serverStarting(MinecraftServer server) {
        manager = new RankManagerImpl(server);
        ((Consumer)RankEvent.REGISTER_CONDITIONS.invoker()).accept(new RegisterConditionsEvent((id, factory) -> manager.registerCondition((String)id, (RankConditionFactory)factory)));
    }

    public static void serverStarted(MinecraftServer server) {
        try {
            manager.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void serverStopped(MinecraftServer server) {
        manager = null;
    }

    public static void worldSaved(ServerLevel event) {
        if (manager != null) {
            manager.saveRanksNow();
            manager.savePlayersNow();
        }
    }

    public static void registerConditions(RegisterConditionsEvent event) {
        event.register("always_active", (rank, json) -> AlwaysActiveCondition.INSTANCE);
        event.register("rank_added", RankAddedCondition::new);
        event.register("rank_applies", RankAppliesCondition::new);
        event.register("not", NotCondition::new);
        event.register("or", OrCondition::new);
        event.register("and", AndCondition::new);
        event.register("xor", XorCondition::new);
        event.register("op", (rank, tag) -> new OPCondition());
        event.register("spawn", (rank, tag) -> new SpawnCondition());
        event.register("dimension", (rank, tag) -> new DimensionCondition(tag));
        event.register("playtime", (rank, tag) -> new PlaytimeCondition(tag));
        event.register("stat", (rank, tag) -> new StatCondition(tag));
        event.register("fake_player", (rank, tag) -> new FakePlayerCondition());
        event.register("creative_mode", (rank, tag) -> new CreativeModeCondition());
    }
}

