/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import net.irisshaders.iris.Iris;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import rainbows.Rainbows;
import rainbows.util.Noise2D;
import rainbows.util.OpenSimplex2D;

public class RHelpers {
    public static final KeyMapping RELOAD_RAINBOW_CONFIGS = new KeyMapping("rainbows.key.reload_rainbow_configs", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, -1, "Rainbows");

    public static ResourceLocation identifier(String name) {
        return RHelpers.resourceLocation("rainbows", name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static ArtifactVersion getVersion() {
        return ((ModContainer)ModList.get().getModContainerById("rainbows").get()).getModInfo().getVersion();
    }

    public static int compareVersions(String oldVersion) {
        return ((ModContainer)ModList.get().getModContainerById("rainbows").get()).getModInfo().getVersion().compareTo((Object)new DefaultArtifactVersion(oldVersion));
    }

    public static boolean areShadersEnabled() {
        if (ModList.get().isLoaded("oculus") || ModList.get().isLoaded("iris")) {
            return Iris.getIrisConfig().areShadersEnabled();
        }
        return false;
    }

    public static Noise2D noise(long seed, int octaves, float scale, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(octaves).spread(0.03f).scaled(-scale, scale);
        return new OpenSimplex2D(seed + 1L).octaves(octaves).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, minHeight, maxHeight);
    }

    public static double noise(double x, long seed, int octaves, int minHeight, int maxHeight, double factor) {
        return RHelpers.noise(seed, octaves, 100.0f, minHeight, maxHeight).noise(x, 0.0) * factor;
    }

    public static double convertToDouble(JsonElement json, String memberName, double fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        Rainbows.LOGGER.error("Expected " + memberName + " to be a Double, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static double getAsDouble(JsonObject json, String memberName, double fallback) {
        return json.has(memberName) ? RHelpers.convertToDouble(json.get(memberName), memberName, fallback) : fallback;
    }

    public static int convertToInt(JsonElement json, String memberName, int fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        Rainbows.LOGGER.error("Expected " + memberName + " to be a Int, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static int getAsInt(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? RHelpers.convertToInt(json.get(memberName), memberName, fallback) : fallback;
    }

    public static boolean convertToBoolean(JsonElement json, String memberName, boolean fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        Rainbows.LOGGER.error("Expected " + memberName + " to be a Boolean, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static boolean getAsBoolean(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? RHelpers.convertToBoolean(json.get(memberName), memberName, fallback) : fallback;
    }

    public static String convertToString(JsonElement json, String memberName, String fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        Rainbows.LOGGER.error("Expected " + memberName + " to be a String, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static String getAsString(JsonObject json, String memberName, String fallback) {
        return json.has(memberName) ? RHelpers.convertToString(json.get(memberName), memberName, fallback) : fallback;
    }
}

