/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import tech.alexnijjar.endermanoverhaul.client.config.EndermanOverhaulClientConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.EndEnderman;

public class FlashOverlay {
    public static boolean shouldFlash;

    public static void render(GuiGraphics graphics) {
        if (!shouldFlash) {
            return;
        }
        if (!EndermanOverhaulClientConfig.flashScreen) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int hurtTime = player.hurtTime;
        if (hurtTime < 5) {
            return;
        }
        DamageSource damageSource = player.getLastDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity entity = damageSource.getEntity();
        if (!(entity instanceof EndEnderman)) {
            return;
        }
        float alpha = (float)(hurtTime - 5) * 0.05f;
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), -1);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (hurtTime == 5) {
            shouldFlash = false;
        }
    }
}

