/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.jei;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.jei.FallingAnvilDisenchantRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilExperienceShardRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilFormRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilRecipe;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollection;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollectionKind;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentEntry;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentKey;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMWellKnownRegistries;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMComponentUtils;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FallingAnvilJEICategory
implements IRecipeCategory<FallingAnvilRecipe> {
    public static final RecipeType<FallingAnvilRecipe> RECIPE_TYPE = RecipeType.create((String)"sfm", (String)"falling_anvil", FallingAnvilRecipe.class);
    private final IDrawable icon;

    public FallingAnvilJEICategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Blocks.ANVIL));
    }

    public RecipeType<FallingAnvilRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return LocalizationKeys.FALLING_ANVIL_JEI_CATEGORY_TITLE.getComponent();
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 54;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static Stream<SFMEnchantmentKey> streamEnchantments() {
        return SFMWellKnownRegistries.ENCHANTMENTS.holders().map(SFMEnchantmentKey::new);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FallingAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> anvil = List.of(new ItemStack((ItemLike)Items.ANVIL), new ItemStack((ItemLike)Items.CHIPPED_ANVIL), new ItemStack((ItemLike)Items.DAMAGED_ANVIL));
        if (recipe instanceof FallingAnvilFormRecipe) {
            FallingAnvilFormRecipe formRecipe = (FallingAnvilFormRecipe)recipe;
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(formRecipe.PARENT.form());
            ItemStack ironBlock = new ItemStack((ItemLike)Blocks.IRON_BLOCK);
            SFMComponentUtils.appendLore(ironBlock, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(ironBlock);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(Arrays.stream(formRecipe.PARENT.form().getItems()).map(FormItem::createFormFromReference).toList());
        } else if (recipe instanceof FallingAnvilDisenchantRecipe) {
            SFMEnchantmentCollection seekingEnchantments = new SFMEnchantmentCollection();
            ArrayList<ItemStack> enchantedInputItems = new ArrayList<ItemStack>();
            focuses.getFocuses(RecipeIngredientRole.INPUT).map(FallingAnvilJEICategory::getIngredientItemStack).filter(Predicate.not(ItemStack::isEmpty)).forEach(inputItemStack -> {
                SFMEnchantmentCollection itemEnchantments = SFMEnchantmentCollection.fromItemStack(inputItemStack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                if (itemEnchantments.isEmpty()) {
                    return;
                }
                seekingEnchantments.addAll(itemEnchantments);
                enchantedInputItems.add((ItemStack)inputItemStack);
            });
            if (enchantedInputItems.isEmpty()) {
                List<Item> defaultTools = List.of(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS, Items.DIAMOND_PICKAXE, Items.DIAMOND_SHOVEL, Items.DIAMOND_AXE, Items.DIAMOND_HOE, Items.DIAMOND_SWORD, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_SWORD, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS, Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SWORD, Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS, Items.WOODEN_PICKAXE, Items.WOODEN_SHOVEL, Items.WOODEN_AXE, Items.WOODEN_HOE, Items.WOODEN_SWORD, Items.BOW, Items.CROSSBOW, Items.TRIDENT, Items.FISHING_ROD, Items.STICK);
                for (Item defaultTool : defaultTools) {
                    enchantedInputItems.add(new ItemStack((ItemLike)defaultTool));
                }
            }
            focuses.getFocuses(RecipeIngredientRole.OUTPUT).map(FallingAnvilJEICategory::getIngredientItemStack).filter(Predicate.not(ItemStack::isEmpty)).map(stack -> SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.HoldingLikeABook)).flatMap(Collection::stream).forEach(seekingEnchantments::add);
            boolean showingAllEnchantments = seekingEnchantments.isEmpty();
            ArrayList<ItemStack> inputEnchantedItemIngredients = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputEnchantedBookIngredients = new ArrayList<ItemStack>();
            Iterable holders = FallingAnvilJEICategory.streamEnchantments()::iterator;
            for (SFMEnchantmentKey enchantmentKey : holders) {
                int maxLevel = enchantmentKey.getMaxLevel();
                IntArraySet enchantmentLevelsToDisplay = new IntArraySet();
                if (showingAllEnchantments) {
                    for (level = 1; level <= maxLevel; ++level) {
                        enchantmentLevelsToDisplay.add(level);
                    }
                } else {
                    level = seekingEnchantments.getLevel(enchantmentKey);
                    if (level <= 0) continue;
                    enchantmentLevelsToDisplay.add(level);
                }
                if (enchantmentLevelsToDisplay.isEmpty()) continue;
                int[] levelsToDisplayIntArray = enchantmentLevelsToDisplay.toIntArray();
                for (ItemStack checkStack : enchantedInputItems) {
                    if (!enchantmentKey.canEnchant(checkStack) && checkStack.getItem() != Items.STICK) continue;
                    for (int level : levelsToDisplayIntArray) {
                        ItemStack toolStack = checkStack.copy();
                        SFMEnchantmentEntry enchantment = new SFMEnchantmentEntry(enchantmentKey, level);
                        SFMEnchantmentCollection collection = new SFMEnchantmentCollection();
                        collection.add(enchantment);
                        collection.write(toolStack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                        ItemStack enchantedBook = enchantment.createEnchantedBook();
                        outputEnchantedBookIngredients.add(enchantedBook);
                        inputEnchantedItemIngredients.add(toolStack);
                    }
                }
            }
            builder.addSlot(RecipeIngredientRole.CATALYST, 8, 0).addItemStacks(anvil);
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.OBSIDIAN);
            SFMComponentUtils.appendLore(obsidian, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.CATALYST, 8, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.INPUT, 18, 18).addItemStack(new ItemStack((ItemLike)Items.BOOK));
            IRecipeSlotBuilder inputEnchantedItemSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addItemStacks(inputEnchantedItemIngredients);
            IRecipeSlotBuilder outputEnchantedBookSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(outputEnchantedBookIngredients);
            if (inputEnchantedItemIngredients.size() == outputEnchantedBookIngredients.size()) {
                builder.createFocusLink(new IIngredientAcceptor[]{inputEnchantedItemSlot, outputEnchantedBookSlot});
            } else {
                SFM.LOGGER.warn("Input and output ingredient counts do not match! This should not happen!");
            }
        } else if (recipe instanceof FallingAnvilExperienceShardRecipe) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.ENCHANTED_BOOK}));
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.OBSIDIAN);
            SFMComponentUtils.appendLore(obsidian, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStack(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get()));
        }
    }

    @MCVersionDependentBehaviour
    private static ItemStack getIngredientItemStack(IFocus<?> focus) {
        return focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.EMPTY);
    }
}

