/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.CableBlock;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.block.shape.ShapeCache;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityDiscovery;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FancyCableBlock
extends CableBlock
implements IFacadableBlock {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final VoxelShape SHAPE_CORE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    public static final Map<Direction, BooleanProperty> DIRECTION_PROPERTIES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.SOUTH, (Object)SOUTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.WEST, (Object)WEST, (Object)Direction.UP, (Object)UP, (Object)Direction.DOWN, (Object)DOWN);

    public FancyCableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IFacadableBlock getNonFacadeBlock() {
        return SFMBlocks.FANCY_CABLE_BLOCK.get();
    }

    @Override
    public IFacadableBlock getFacadeBlock() {
        return SFMBlocks.FANCY_CABLE_FACADE_BLOCK.get();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getState(this.defaultBlockState(), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level level, @Stored BlockPos pos, Block block, @Stored BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        level.setBlockAndUpdate(pos, this.getState(level.getBlockState(pos), (LevelAccessor)level, pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, @NotStored BlockPos pos, CollisionContext ctx) {
        return ShapeCache.getOrCompute(state, FancyCableBlock::getShape);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor world, @NotStored BlockPos pos, @NotStored BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    @Override
    public BlockState getStateForPlacementByFacadePlan(LevelAccessor level, @NotStored BlockPos pos) {
        return this.getState(this.defaultBlockState(), level, pos);
    }

    protected static VoxelShape getShape(BlockState state) {
        VoxelShape shape = SHAPE_CORE;
        shape = FancyCableBlock.combineShapes(shape, SHAPE_NORTH, () -> (Boolean)state.getValue((Property)NORTH));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_SOUTH, () -> (Boolean)state.getValue((Property)SOUTH));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_EAST, () -> (Boolean)state.getValue((Property)EAST));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_WEST, () -> (Boolean)state.getValue((Property)WEST));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_UP, () -> (Boolean)state.getValue((Property)UP));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_DOWN, () -> (Boolean)state.getValue((Property)DOWN));
        return shape;
    }

    protected static VoxelShape combineShapes(VoxelShape shape1, VoxelShape shape2, Supplier<Boolean> condition) {
        return condition.get() != false ? Shapes.or((VoxelShape)shape1, (VoxelShape)shape2) : shape1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    protected BlockState getState(BlockState currentState, LevelAccessor level, @NotStored BlockPos pos) {
        boolean north = this.hasConnection(level, pos, Direction.NORTH);
        boolean south = this.hasConnection(level, pos, Direction.SOUTH);
        boolean east = this.hasConnection(level, pos, Direction.EAST);
        boolean west = this.hasConnection(level, pos, Direction.WEST);
        boolean up = this.hasConnection(level, pos, Direction.UP);
        boolean down = this.hasConnection(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    protected boolean hasConnection(LevelAccessor level, @NotStored BlockPos pos, Direction direction) {
        BlockPos relative = pos.relative(direction);
        if (level.getBlockState(relative).getBlock() instanceof ICableBlock) {
            return true;
        }
        return SFMBlockCapabilityDiscovery.hasAnyCapabilityAnyDirection(level, relative);
    }
}

