/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.command;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.command.ConfigCommandVariantInput;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMConfigReadWriter;
import ca.teamdman.sfm.common.net.ClientboundClientConfigCommandPacket;
import ca.teamdman.sfm.common.net.ClientboundServerConfigCommandPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public record ConfigCommand(ConfigCommandBehaviourInput behaviour, ConfigCommandVariantInput variant) implements Command<CommandSourceStack>
{
    public static final int FAILURE = 0;

    public int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = this.getPlayer(ctx);
        if (player == null) {
            return 0;
        }
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ConfigCommandVariantInput.CLIENT -> this.handleClientConfigCommand(player);
            case ConfigCommandVariantInput.SERVER -> this.handleServerConfigCommand(player);
        };
    }

    @Nullable
    private ServerPlayer getPlayer(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (player == null) {
            SFM.LOGGER.error("Received config command ({} {}) from null player!?", (Object)this.variant, (Object)this.behaviour);
            return null;
        }
        SFM.LOGGER.info("Received config command ({} {}) from player {}", (Object)this.variant, (Object)this.behaviour, (Object)player);
        return player;
    }

    private int handleClientConfigCommand(ServerPlayer player) {
        SFMPackets.sendToPlayer(player, (SFMPacket)new ClientboundClientConfigCommandPacket(this.behaviour));
        return 0;
    }

    private int handleServerConfigCommand(ServerPlayer player) {
        String configToml = SFMConfigReadWriter.getConfigToml(SFMConfig.SERVER_CONFIG_SPEC);
        if (configToml == null) {
            SFM.LOGGER.warn("Unable to get server config for player {} to {}", (Object)player.getName().getString(), (Object)this.behaviour);
            player.sendSystemMessage((Component)SFMConfigReadWriter.ConfigSyncResult.FAILED_TO_FIND.component().withStyle(ChatFormatting.RED));
        } else {
            SFMPackets.sendToPlayer(player, (SFMPacket)new ClientboundServerConfigCommandPacket(configToml, this.behaviour));
        }
        return 1;
    }
}

