/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.common.facade.FacadeTextureMode;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record FacadeData(BlockState facadeBlockState, Direction facadeDirection, FacadeTextureMode facadeTextureMode) {
    public void save(CompoundTag tag) {
        CompoundTag facadeTag = new CompoundTag();
        facadeTag.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)this.facadeBlockState()));
        facadeTag.putString("direction", this.facadeDirection().getSerializedName());
        facadeTag.putString("texture_mode", this.facadeTextureMode().getSerializedName());
        tag.put("sfm:facade", (Tag)facadeTag);
    }

    @Nullable
    public static FacadeData load(@Nullable Level level, CompoundTag tag) {
        if (tag.contains("sfm:facade", 10)) {
            CompoundTag facadeTag = tag.getCompound("sfm:facade");
            BlockState facadeState = FacadeData.readBlockState(facadeTag.getCompound("block_state"), level);
            Direction facadeDirection = Direction.byName((String)facadeTag.getString("direction"));
            FacadeTextureMode facadeTextureMode = FacadeTextureMode.byName(facadeTag.getString("texture_mode"));
            if (facadeTextureMode != null && facadeDirection != null) {
                return new FacadeData(facadeState, facadeDirection, facadeTextureMode);
            }
        }
        return null;
    }

    @MCVersionDependentBehaviour
    private static BlockState readBlockState(CompoundTag tag, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        return NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)tag);
    }
}

