/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.tokenizers;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.simmetrics.tokenizers.AbstractTokenizer;
import org.simmetrics.tokenizers.Tokenizer;

public final class Tokenizers {
    public static Tokenizer pattern(Pattern pattern) {
        return new Split(pattern);
    }

    public static Tokenizer pattern(String regex) {
        return Tokenizers.pattern(Pattern.compile(regex));
    }

    public static Tokenizer qGram(int q) {
        return new QGram(q);
    }

    public static Tokenizer qGramWithFilter(int q) {
        return new QGram(q, true);
    }

    public static Tokenizer qGramWithPadding(int q) {
        return new QGramExtended(q);
    }

    public static Tokenizer qGramWithPadding(int q, String padding) {
        return Tokenizers.qGramWithPadding(q, padding, padding);
    }

    public static Tokenizer qGramWithPadding(int q, String startPadding, String endPadding) {
        return new QGramExtended(q, startPadding, endPadding);
    }

    public static Tokenizer whitespace() {
        return new Whitespace();
    }

    public static Tokenizer transform(Tokenizer tokenizer, Function<String, String> function) {
        if (tokenizer instanceof Transform) {
            return Transform.createCombined((Transform)tokenizer, function);
        }
        if (tokenizer instanceof Filter) {
            return Transform.createCombined((Filter)tokenizer, function);
        }
        return new Transform(tokenizer, function);
    }

    public static Tokenizer chain(List<Tokenizer> tokenizers) {
        if (tokenizers.size() == 1) {
            return tokenizers.get(0);
        }
        return new Recursive(Tokenizers.flatten(tokenizers));
    }

    private static List<Tokenizer> flatten(List<Tokenizer> simplifiers) {
        ImmutableList.Builder flattend = ImmutableList.builder();
        for (Tokenizer s : simplifiers) {
            if (s instanceof Recursive) {
                Recursive c = (Recursive)s;
                flattend.addAll(c.getTokenizers());
                continue;
            }
            flattend.add((Object)s);
        }
        return flattend.build();
    }

    public static Tokenizer chain(Tokenizer tokenizer, Tokenizer ... tokenizers) {
        Preconditions.checkNotNull((Object)tokenizer);
        if (tokenizers.length == 0) {
            return tokenizer;
        }
        return new Recursive(Tokenizers.flatten(Lists.asList((Object)tokenizer, (Object[])tokenizers)));
    }

    public static Tokenizer filter(Tokenizer tokenizer, Predicate<String> predicate) {
        if (tokenizer instanceof Filter) {
            return Filter.createCombined((Filter)tokenizer, predicate);
        }
        if (tokenizer instanceof Transform) {
            return Filter.createCombined((Transform)tokenizer, predicate);
        }
        return new Filter(tokenizer, predicate);
    }

    private Tokenizers() {
    }

    static final class Split
    extends AbstractTokenizer {
        private final Pattern pattern;

        public Split(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            return Arrays.asList(this.pattern.split(input, -1));
        }

        public String toString() {
            return "Split[" + String.valueOf(this.pattern) + "]";
        }

        Pattern getPattern() {
            return this.pattern;
        }
    }

    static class QGram
    extends AbstractTokenizer {
        private final int q;
        private final boolean filter;

        QGram(int q, boolean filter) {
            Preconditions.checkArgument((q > 0 ? 1 : 0) != 0, (Object)"q must be greater then 0");
            this.q = q;
            this.filter = filter;
        }

        public QGram(int q) {
            this(q, false);
        }

        int getQ() {
            return this.q;
        }

        boolean isFilter() {
            return this.filter;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            int lastQGramStart;
            if (input.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.filter && input.length() < this.q) {
                return new ArrayList<String>();
            }
            if (input.length() < this.q) {
                return Collections.singletonList(input);
            }
            try {
                lastQGramStart = input.offsetByCodePoints(input.length(), -this.q);
            }
            catch (IndexOutOfBoundsException e) {
                if (this.filter) {
                    return new ArrayList<String>();
                }
                return Collections.singletonList(input);
            }
            ArrayList<String> ret = new ArrayList<String>(input.length());
            int qGramStart = 0;
            while (qGramStart <= lastQGramStart) {
                ret.add(input.substring(qGramStart, input.offsetByCodePoints(qGramStart, this.q)));
                qGramStart = input.offsetByCodePoints(qGramStart, 1);
            }
            return ret;
        }

        public String toString() {
            return "QGram [q=" + this.q + "]";
        }
    }

    static class QGramExtended
    extends AbstractTokenizer {
        private static final String DEFAULT_START_PADDING = "#";
        private static final String DEFAULT_END_PADDING = "#";
        private final String endPadding;
        private final String startPadding;
        private final QGram tokenizer;

        public QGramExtended(int q, String startPadding, String endPadding) {
            Preconditions.checkArgument((!startPadding.isEmpty() ? 1 : 0) != 0, (Object)"startPadding may not be empty");
            Preconditions.checkArgument((!endPadding.isEmpty() ? 1 : 0) != 0, (Object)"endPadding may not be empty");
            this.tokenizer = new QGram(q);
            this.startPadding = Strings.repeat((String)startPadding, (int)(q - 1));
            this.endPadding = Strings.repeat((String)endPadding, (int)(q - 1));
        }

        public QGramExtended(int q) {
            this(q, "#", "#");
        }

        @Override
        public List<String> tokenizeToList(String input) {
            if (input.isEmpty()) {
                return Collections.emptyList();
            }
            return this.tokenizer.tokenizeToList(this.startPadding + input + this.endPadding);
        }

        public String toString() {
            return "QGramExtended [startPadding=" + this.startPadding + ", endPadding=" + this.endPadding + ", q=" + this.tokenizer.getQ() + "]";
        }

        int getQ() {
            return this.tokenizer.getQ();
        }

        String getStartPadding() {
            return this.startPadding;
        }

        String getEndPadding() {
            return this.endPadding;
        }
    }

    static final class Whitespace
    extends AbstractTokenizer {
        private final Pattern pattern = Pattern.compile("\\s+");

        Whitespace() {
        }

        @Override
        public List<String> tokenizeToList(String input) {
            if (input.isEmpty()) {
                return Collections.emptyList();
            }
            String[] tokens = this.pattern.split(input);
            if (tokens.length > 0 && tokens[0].isEmpty()) {
                tokens = Arrays.copyOfRange(tokens, 1, tokens.length);
            }
            return Arrays.asList(tokens);
        }

        public String toString() {
            return "Whitespace";
        }
    }

    static class Transform
    implements Tokenizer {
        protected final Function<String, String> function;
        private final Tokenizer tokenizer;

        static Tokenizer createCombined(Filter tokenizer, Function<String, String> function) {
            return new FilterTransform(tokenizer, function);
        }

        static Tokenizer createCombined(Transform tokenizer, Function<String, String> function) {
            if (tokenizer instanceof FilterTransform) {
                FilterTransform ftt = (FilterTransform)tokenizer;
                return new FilterTransform(ftt.getTokenizer(), (Function<String, String>)Functions.compose(function, tokenizer.getFunction()));
            }
            return new Transform(tokenizer.getTokenizer(), (Function<String, String>)Functions.compose(function, tokenizer.getFunction()));
        }

        Transform(Tokenizer tokenizer, Function<String, String> function) {
            Preconditions.checkNotNull((Object)tokenizer);
            Preconditions.checkNotNull(function);
            this.function = function;
            this.tokenizer = tokenizer;
        }

        Function<String, String> getFunction() {
            return this.function;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            return Lists.newArrayList((Iterable)Collections2.transform(this.tokenizer.tokenizeToList(input), this.function));
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            return HashMultiset.create((Iterable)Collections2.transform(this.tokenizer.tokenizeToMultiset(input), this.function));
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            return Sets.newHashSet((Iterable)Collections2.transform(this.tokenizer.tokenizeToSet(input), this.function));
        }

        Collection<String> tokenizeToTransformedList(String input) {
            return Lists.transform(this.tokenizer.tokenizeToList(input), this.function);
        }

        Collection<String> tokenizeToTransformedMultiset(String input) {
            return Collections2.transform(this.tokenizer.tokenizeToMultiset(input), this.function);
        }

        Collection<String> tokenizeToTransformedSet(String input) {
            return Collections2.transform(this.tokenizer.tokenizeToSet(input), this.function);
        }

        public final String toString() {
            return Joiner.on((String)" -> ").join((Object)this.tokenizer, this.function, new Object[0]);
        }

        static final class FilterTransform
        extends Transform {
            private final Filter tokenizer;

            FilterTransform(Filter tokenizer, Function<String, String> function) {
                super(tokenizer, function);
                this.tokenizer = tokenizer;
            }

            @Override
            Filter getTokenizer() {
                return this.tokenizer;
            }

            @Override
            public List<String> tokenizeToList(String input) {
                return Lists.newArrayList((Iterable)Collections2.transform(this.tokenizer.tokenizeToFilteredList(input), (Function)this.function));
            }

            @Override
            public Multiset<String> tokenizeToMultiset(String input) {
                return HashMultiset.create((Iterable)Collections2.transform(this.tokenizer.tokenizeToFilteredMultiset(input), (Function)this.function));
            }

            @Override
            public Set<String> tokenizeToSet(String input) {
                return Sets.newHashSet((Iterable)Collections2.transform(this.tokenizer.tokenizeToFilteredSet(input), (Function)this.function));
            }

            @Override
            Collection<String> tokenizeToTransformedList(String input) {
                return Collections2.transform(this.tokenizer.tokenizeToFilteredList(input), (Function)this.function);
            }

            @Override
            Collection<String> tokenizeToTransformedMultiset(String input) {
                return Collections2.transform(this.tokenizer.tokenizeToFilteredMultiset(input), (Function)this.function);
            }

            @Override
            Collection<String> tokenizeToTransformedSet(String input) {
                return Collections2.transform(this.tokenizer.tokenizeToFilteredSet(input), (Function)this.function);
            }
        }
    }

    static class Filter
    implements Tokenizer {
        protected final Predicate<String> predicate;
        private final Tokenizer tokenizer;

        static Tokenizer createCombined(Filter tokenizer, Predicate<String> predicate) {
            if (tokenizer instanceof TransformFilter) {
                TransformFilter tft = (TransformFilter)tokenizer;
                return new TransformFilter(tft.getTokenizer(), (Predicate<String>)Predicates.and(tft.getPredicate(), predicate));
            }
            return new Filter(tokenizer.getTokenizer(), (Predicate<String>)Predicates.and(tokenizer.getPredicate(), predicate));
        }

        static Tokenizer createCombined(Transform tokenizer, Predicate<String> predicate) {
            return new TransformFilter(tokenizer, predicate);
        }

        Filter(Tokenizer tokenizer, Predicate<String> predicate) {
            Preconditions.checkNotNull((Object)tokenizer);
            Preconditions.checkNotNull(predicate);
            this.predicate = predicate;
            this.tokenizer = tokenizer;
        }

        Predicate<String> getPredicate() {
            return this.predicate;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        Collection<String> tokenizeToFilteredList(String input) {
            return Collections2.filter(this.tokenizer.tokenizeToList(input), this.predicate);
        }

        Collection<String> tokenizeToFilteredMultiset(String input) {
            return Collections2.filter(this.tokenizer.tokenizeToMultiset(input), this.predicate);
        }

        Collection<String> tokenizeToFilteredSet(String input) {
            return Sets.filter(this.tokenizer.tokenizeToSet(input), this.predicate);
        }

        @Override
        public List<String> tokenizeToList(String input) {
            return new ArrayList<String>(Collections2.filter(this.tokenizer.tokenizeToList(input), this.predicate));
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            return HashMultiset.create((Iterable)Multisets.filter(this.tokenizer.tokenizeToMultiset(input), this.predicate));
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            return new HashSet<String>(Collections2.filter(this.tokenizer.tokenizeToSet(input), this.predicate));
        }

        public final String toString() {
            return Joiner.on((String)" -> ").join((Object)this.tokenizer, this.predicate, new Object[0]);
        }

        static final class TransformFilter
        extends Filter {
            private final Transform tokenizer;

            TransformFilter(Transform tokenizer, Predicate<String> predicate) {
                super(tokenizer, predicate);
                this.tokenizer = tokenizer;
            }

            @Override
            Transform getTokenizer() {
                return this.tokenizer;
            }

            @Override
            Collection<String> tokenizeToFilteredList(String input) {
                return Collections2.filter(this.tokenizer.tokenizeToTransformedList(input), (Predicate)this.predicate);
            }

            @Override
            Collection<String> tokenizeToFilteredMultiset(String input) {
                return Collections2.filter(this.tokenizer.tokenizeToTransformedMultiset(input), (Predicate)this.predicate);
            }

            @Override
            Collection<String> tokenizeToFilteredSet(String input) {
                return Collections2.filter(this.tokenizer.tokenizeToTransformedSet(input), (Predicate)this.predicate);
            }

            @Override
            public List<String> tokenizeToList(String input) {
                return Lists.newArrayList((Iterable)Collections2.filter(this.tokenizer.tokenizeToTransformedList(input), (Predicate)this.predicate));
            }

            @Override
            public Multiset<String> tokenizeToMultiset(String input) {
                return HashMultiset.create((Iterable)Collections2.filter(this.tokenizer.tokenizeToTransformedMultiset(input), (Predicate)this.predicate));
            }

            @Override
            public Set<String> tokenizeToSet(String input) {
                return Sets.newHashSet((Iterable)Collections2.filter(this.tokenizer.tokenizeToTransformedSet(input), (Predicate)this.predicate));
            }
        }
    }

    static final class Recursive
    implements Tokenizer {
        private final List<Tokenizer> tokenizers;

        Recursive(List<Tokenizer> tokenizers) {
            this.tokenizers = ImmutableList.copyOf(tokenizers);
        }

        List<Tokenizer> getTokenizers() {
            return this.tokenizers;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            ArrayList<String> tokens = new ArrayList<String>(input.length());
            tokens.add(input);
            ArrayList<Object> newTokens = new ArrayList<String>(input.length());
            for (Tokenizer t : this.tokenizers) {
                for (String token : tokens) {
                    newTokens.addAll(t.tokenizeToList(token));
                }
                ArrayList<String> swap = tokens;
                tokens = newTokens;
                newTokens = swap;
                newTokens.clear();
            }
            return tokens;
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            HashMultiset tokens = HashMultiset.create((int)input.length());
            tokens.add((Object)input);
            HashMultiset newTokens = HashMultiset.create((int)input.length());
            for (Tokenizer t : this.tokenizers) {
                for (String token : tokens) {
                    newTokens.addAll(t.tokenizeToList(token));
                }
                HashMultiset swap = tokens;
                tokens = newTokens;
                newTokens = swap;
                newTokens.clear();
            }
            return tokens;
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            HashSet<String> tokens = new HashSet<String>(input.length());
            tokens.add(input);
            HashSet<Object> newTokens = new HashSet<String>(input.length());
            for (Tokenizer t : this.tokenizers) {
                for (String token : tokens) {
                    newTokens.addAll(t.tokenizeToList(token));
                }
                HashSet<String> swap = tokens;
                tokens = newTokens;
                newTokens = swap;
                newTokens.clear();
            }
            return tokens;
        }

        public String toString() {
            return Joiner.on((String)" -> ").join(this.tokenizers);
        }
    }
}

