/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CopperLadder
extends LadderBlock
implements IWeatheringBlock {
    private final WeatheringCopper.WeatherState weatherState;

    public CopperLadder(WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = state;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        this.changeOverTime(blockState, level, blockPos, random);
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return WeatheringCopper.getNext((Block)blockState.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    private boolean isSupportSolid(BlockGetter level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.isFaceSturdy(level, pos, Direction.UP);
    }

    private boolean isCopperLadder(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof CopperLadder;
    }

    public boolean canSurvive(BlockState blockState, LevelReader level, BlockPos pos) {
        return super.canSurvive(blockState, level, pos) || this.isSupportSolid((BlockGetter)level, pos.above()) || this.isCopperLadder((BlockGetter)level, pos.below());
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor level, BlockPos blockPos, BlockPos blockPos1) {
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            level.scheduleTick(blockPos, (Block)this, 1);
        }
        return super.updateShape(blockState, direction, blockState1, level, blockPos, blockPos1);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!blockState.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }
}

