/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.EntryIntegerEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

public class MapIntegerEntry
extends MapBaseEntry<Integer> {
    public MapIntegerEntry(String nameKey, Map<String, Integer> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Integer> getValueCodec() {
        return Codec.INT;
    }

    @Override
    public IConfigEntry<Map.Entry<String, Integer>> newSingleInstance(Integer value, final String key, final Runnable reload) {
        return new EntryIntegerEntry(this.nameKey, new AbstractMap.SimpleEntry<String, Integer>(key, value)){

            @Override
            public void reset() {
                ((Map)MapIntegerEntry.this.getValue()).remove(key);
                reload.run();
            }

            @Override
            public void setValue(Map.Entry<String, Integer> value) {
                if (!Objects.equals(((Map.Entry)this.value).getKey(), value.getKey())) {
                    ((Map)MapIntegerEntry.this.getValue()).remove(((Map.Entry)this.value).getKey());
                    ((Map)MapIntegerEntry.this.getValue()).put(value.getKey(), value.getValue());
                } else if (!Objects.equals(((Map.Entry)this.value).getValue(), value.getValue())) {
                    ((Map)MapIntegerEntry.this.getValue()).put((String)((Map.Entry)this.value).getKey(), value.getValue());
                }
                super.setValue(value);
            }
        };
    }

    @Override
    public Integer newValue() {
        return 0;
    }

    @Override
    public ConfigType<Map<String, Integer>> getType() {
        return ConfigTypes.MAP_INTEGER;
    }

    @Override
    public IConfigEntry<Map<String, Integer>> newInstance() {
        return new MapIntegerEntry(this.nameKey, (Map)this.defaultValue).visible(this.visible).json(this.jsonKey);
    }
}

