/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import com.iafenvoy.jupiter.network.payload.ConfigErrorPayload;
import com.iafenvoy.jupiter.network.payload.ConfigRequestPayload;
import com.iafenvoy.jupiter.network.payload.ConfigSyncPayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class ServerConfigNetwork {
    public static void init() {
        ServerNetworkHelper.registerReceiver(ConfigRequestPayload.ID, (server, player, payload) -> {
            CompoundTag compound;
            ResourceLocation id = payload.id();
            Jupiter.LOGGER.info("Player {} request to get config {}", (Object)player.getName().getString(), (Object)id);
            boolean b = ServerConfigManager.checkPermission(id, server, player, false);
            if (b) {
                AbstractConfigContainer data = ServerConfigManager.getConfig(id);
                assert (data != null);
                compound = (CompoundTag)data.serializeNbt();
            } else {
                compound = new CompoundTag();
            }
            return () -> ServerNetworkHelper.sendToPlayer(player, new ConfigSyncPayload(id, b, compound));
        });
        ServerNetworkHelper.registerReceiver(ConfigSyncPayload.ID, (server, player, payload) -> {
            ResourceLocation id = payload.id();
            Jupiter.LOGGER.info("Player {} request to change config {}", (Object)player.getName().getString(), (Object)id);
            CompoundTag data = payload.compound();
            return () -> {
                if (ServerConfigManager.checkPermission(id, server, player, true)) {
                    AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                    if (container != null) {
                        Jupiter.LOGGER.info(data.toString());
                        container.deserializeNbt((Tag)data);
                        container.onConfigsChanged();
                        Jupiter.LOGGER.info("Player {} changed config {}", (Object)player.getName().getString(), (Object)id);
                    }
                } else {
                    ServerNetworkHelper.sendToPlayer(player, new ConfigErrorPayload());
                }
            };
        });
    }
}

