/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.arseng;

import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.items.storage.StorageTier;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.item.PortableSourceCellItem;
import gripe._90.arseng.item.SourceCellItem;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.IntegrationHelper;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ArsEngIntegration
implements IntegrationHelper {
    @Override
    public Function<Item.Properties, Item> createCell(StorageTier tier) {
        return p -> new SourceCellItem(p, tier);
    }

    @Override
    public Function<Item.Properties, Item> createPortable(StorageTier tier) {
        return p -> new PortableSourceCellItem(this, (Item.Properties)p, tier){

            public ResourceLocation getRecipeId() {
                return MEGACells.makeId("cells/portable/" + Objects.requireNonNull(this.getRegistryName()).getPath());
            }
        };
    }

    @Override
    public void initUpgrades() {
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            if (!cell.keyType().equals("source")) continue;
            Upgrades.add((ItemLike)AEItems.VOID_CARD, cell.item(), (int)1, (String)GuiText.StorageCells.getTranslationKey());
            if (!cell.portable()) continue;
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, cell.item(), (int)2, (String)GuiText.PortableCells.getTranslationKey());
        }
        for (MEGAItems.CellDefinition cell : ArsEngItems.getPortables()) {
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)cell, (int)2, (String)GuiText.PortableCells.getTranslationKey());
        }
    }
}

