/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api;

import com.ldtteam.common.fakelevel.SingleBlockFakeLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final SingleBlockFakeLevel.SidedSingleBlockFakeLevel ITEM_HANDLER_FAKE_LEVEL = new SingleBlockFakeLevel.SidedSingleBlockFakeLevel();

    private ItemStackUtils() {
    }

    public static List<ItemStack> getItemStacksOfTileEntity(CompoundTag compound, BlockState state, Level level) {
        if (compound == null) {
            return List.of();
        }
        BlockPos blockpos = new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
        BlockEntity tileEntity = BlockEntity.loadStatic((BlockPos)blockpos, (BlockState)state, (CompoundTag)compound, (HolderLookup.Provider)level.registryAccess());
        if (tileEntity == null) {
            return List.of();
        }
        return (List)ITEM_HANDLER_FAKE_LEVEL.get(level).useFakeLevelContext(state, tileEntity, level, fakeLevel -> {
            ArrayList items = new ArrayList();
            ItemStackUtils.getItemHandlersFromProvider(tileEntity, blockpos, state).forEach(itemHandler -> ItemStackUtils.deepExtractItemHandler(itemHandler, items::add));
            return items;
        });
    }

    public static void deepExtractItemHandler(@Nullable IItemHandler handler, Consumer<ItemStack> sink) {
        if (handler == null) {
            return;
        }
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot).copy();
            if (ItemStackUtils.isEmpty(stack)) continue;
            sink.accept(stack);
            ItemStackUtils.deepExtractItemHandler((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), sink);
        }
    }

    public static Set<IItemHandler> getItemHandlersFromProvider(@Nullable BlockEntity provider, BlockPos pos, BlockState state) {
        if (provider == null) {
            return Set.of();
        }
        if (provider instanceof IItemHandler) {
            IItemHandler itemHandler = (IItemHandler)provider;
            return Set.of(itemHandler);
        }
        if (provider instanceof Container) {
            Container container = (Container)provider;
            return Set.of(new InvWrapper(container));
        }
        IItemHandler unsidedItemHandler = (IItemHandler)provider.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, pos, state, provider, null);
        if (unsidedItemHandler != null) {
            return Set.of(unsidedItemHandler);
        }
        HashSet<IItemHandler> handlerSet = new HashSet<IItemHandler>();
        for (Direction side : Direction.values()) {
            IItemHandler cap = (IItemHandler)provider.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, pos, state, provider, (Object)side);
            if (cap == null) continue;
            handlerSet.add(cap);
        }
        return handlerSet;
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.isEmpty() || stack == ItemStack.EMPTY || stack.getCount() <= 0;
    }

    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return 0;
        }
        return stack.getCount();
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public static List<ItemStack> getListOfStackForEntity(Entity entity, BlockPos pos) {
        return ItemStackUtils.getListOfStackForEntity(entity);
    }

    public static List<ItemStack> getListOfStackForEntity(Entity entity) {
        if (entity == null) {
            return List.of();
        }
        ArrayList<ItemStack> request = new ArrayList<ItemStack>();
        ItemStack spawnItem = ItemStackUtils.getEntitySpawningItem(entity);
        if (spawnItem != null && !(spawnItem.getItem() instanceof SpawnEggItem)) {
            request.add(spawnItem);
        }
        request.addAll(ItemStackUtils.getItemStacksOfEntity(entity));
        return request.stream().filter(stack -> !stack.isEmpty()).toList();
    }

    public static List<ItemStack> getItemStacksOfEntity(Entity entity) {
        if (entity == null) {
            return List.of();
        }
        ArrayList<ItemStack> entityContent = new ArrayList<ItemStack>();
        IItemHandler itemHandler = null;
        if (entity instanceof IItemHandler) {
            IItemHandler iitemHandler;
            itemHandler = iitemHandler = (IItemHandler)entity;
        } else if (entity instanceof Container) {
            Container container = (Container)entity;
            itemHandler = new InvWrapper(container);
        }
        if (itemHandler == null) {
            itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        }
        if (itemHandler == null) {
            itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, null);
        }
        if (itemHandler != null) {
            ItemStackUtils.deepExtractItemHandler(itemHandler, entityContent::add);
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            ItemStack stack = itemFrame.getItem();
            entityContent.add(stack);
            ItemStackUtils.deepExtractItemHandler((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), entityContent::add);
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.getItem();
            entityContent.add(stack);
            ItemStackUtils.deepExtractItemHandler((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), entityContent::add);
        } else {
            for (Direction side : Direction.values()) {
                IItemHandler cap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
                if (cap == null) continue;
                ItemStackUtils.deepExtractItemHandler(cap, entityContent::add);
            }
        }
        return entityContent;
    }

    @Nullable
    public static ItemStack getEntitySpawningItem(Entity entity) {
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            return itemFrame.getFrameItemStack();
        }
        return entity.getPickedResult((HitResult)new EntityHitResult(entity));
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1) && ItemStackUtils.isEmpty(itemStack2)) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.getItem() != itemStack2.getItem() || matchDamage && itemStack1.getDamageValue() != itemStack2.getDamageValue())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.getCount() > itemStack2.getCount()) {
                return false;
            }
            if (!itemStack1.getComponents().isEmpty() && !itemStack2.getComponents().isEmpty()) {
                DataComponentMap nbt1 = itemStack1.getComponents();
                DataComponentMap nbt2 = itemStack2.getComponents();
                for (DataComponentType key : nbt1.keySet()) {
                    if (!matchDamage && key == DataComponents.DAMAGE || nbt2.has(key) && nbt1.get(key).equals(nbt2.get(key))) continue;
                    return false;
                }
                return nbt1.keySet().size() == nbt2.keySet().size();
            }
            return itemStack1.getComponents().isEmpty() == itemStack2.getComponents().isEmpty();
        }
        return false;
    }
}

